<h2>Why is this an issue?</h2>
<p>The ECMAScript specification allows for creating block-level lexical declarations (<code>let</code>, <code>const</code>, <code>function</code>, and
<code>class</code>) in any block statement or expression. However, when these declarations are made inside the <code>case</code> or
<code>default</code> clause of a <code>switch</code> statement, they are not confined to the block of that <code>case</code> or <code>default</code>
clause. Instead, they apply to the whole <code>switch</code> block but only get initialized when the cases are reached, which can lead to unexpected
behavior.</p>

```ts
switch (foo) {
    case 1:
        let x = 1; // Noncompliant
        break;
    case 2:
        const y = 2; // Noncompliant
        break;
    case 3:
        function f() {} // Noncompliant
        break;
    case 4:
        class C {} // Noncompliant
        break;
}
```
<p>To fix this, you can create a nested block within each <code>case</code> or <code>default</code> clause, ensuring each declaration is properly
scoped to its respective block.</p>

```ts
switch (foo) {
    case 1: {
        let x = 1;
        break;
    }
    case 2: {
        const y = 2;
        break;
    }
    case 3: {
        function f() {}
        break;
    }
    case 4: {
        class C {}
        break;
    }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/switch">switch</a> </li>
</ul>