This check detects the usage of optional and default method parameters.

# What Does This Check Look For?

This check detects optional parameters, indicated by `OPTIONAL` or `DEFAULT`, which are used in a `METHOD` definition.

This check **does not** process constructor methods.
# Why is This a Problem?

Optional parameters confuse callers:

+ Which ones are really required?
+ Which combinations are valid?
+ Which ones exclude each other?

Providing multiple methods for different use cases avoids this confusion by giving guidance on their usage with explicit names and expected parameter combinations.
# How Can I Resolve This?

Consider splitting methods with `OPTIONAL` parameters into smaller and more specific methods. This also makes code easier to understand from a caller's perspective.

Methods with a `DEFAULT` parameter can get split into two methods where the first method has the default parameter as a **mandatory** parameter
and the second method does not have the parameter. Inside the second method you can now call the first one and supply it with the wanted default value.

# Examples
## Non-Compliant

```$ABAP
METHODS write_data
    IMPORTING
        with_commit TYPE abap_bool OPTIONAL.
        
METHODS create_json
    IMPORTING
        data TYPE ANY TABLE
        case TYPE string DEFAULT 'CamelCase'.
```

## Compliant

```$ABAP
METHODS write_data_with_commit.

METHODS write_data_without_commit.

METHODS create_json
    IMPORTING
        data TYPE ANY TABLE
        case TYPE string.


METHODS create_json_camel_case
    IMPORTING
        data TYPE ANY TABLE.
        
*=====================================*

METHOD create_json_camel_case
    create_json(
        exporting
            data = data
            case = 'CamelCase' ).  
ENDMETHOD.
```

# Where Can I Learn More?
[Clean ABAP: Split methods instead of adding OPTIONAL parameters](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#split-methods-instead-of-adding-optional-parameters)