The functions `equals()` and `toString()` should not be called on arrays.

# Why is This a Problem?
The usage of these functions is discouraged since they have an unintuitive behavior.
Calling `equals()` on an array does not check the contents of the array for
equality, but rather its memory addresses.
In the same way calling `toString()` on an array will not return the String
representation of the content of the array, but the memory address.
Therefore, this is likely a bug.

# How Can I Resolve This?
These issues can be resolved by using functions from `java.util.Arrays`. 
A nicely readable representation of an array can be obtained by using the function `Arrays.toString()`.
The contents of two arrays can be compared by using `Arrays.equals()`.
Note that `Arrays.equals()` only works for one-dimensional arrays.
Multidimensional arrays need to be compared with `Arrays.deepEquals()`.

## Example (Before)
```java
int[] arr1 = new int [] {1, 2, 3};
int[] arr2 = new int [] {1, 2, 3, 4};
String arr1String = arr1.toString();
bool areEqual = arr1.equals(arr2);
```

## Example (After)
```java
import java.util.Arrays;
...
int[] arr1 = new int [] {1, 2, 3};
int[] arr2 = new int [] {1, 2, 3, 4};
String arr1String = Arrays.toString(arr1);
bool areEqual = Arrays.equals(arr1, arr2);
```
