Hash algorithms like SHA-1 or MD5 are considered insecure by modern security standards.
Consider using more secure alternatives, such as the SHA-2 (e.g., SHA-256, SHA-512) or SHA-3 family of hash functions, for cryptographic purposes.

# What Does This Check Look For?

This check reports a finding when an insecure algorithm (SHA1, MD5, RIPEMD, etc.) is used within the code, potentially for password hashing or as part of digital signatures.

# Why is This a Problem?
Due to vulnerabilities in several insecure algorithms, such as SHA1, MD5, RIPEMD, etc., they are no longer considered safe for cryptographic purposes.
This compromises the integrity and security of data, potentially exposing sensitive information to unauthorized access.

# How Can I Resolve This?

Consider migrating to more secure hashing algorithms such as SHA-256 or SHA-3.
These algorithms offer stronger security guarantees and are less susceptible to collision attacks.

# Examples

## Non-Compliant

```java
MessageDigest.getInstance("SHA-1"); // non-compliant: SHA-1 is insecure
```

## Compliant

```java
MessageDigest.getInstance("SHA-256"); // compliant: SHA-256 is more secure
```

# Where Can I Learn More?

- [Testing for Weak Encryption](https://owasp.org/www-project-web-security-testing-guide/latest/4-Web_Application_Security_Testing/09-Testing_for_Weak_Cryptography/04-Testing_for_Weak_Encryption)
- [Kryptographische Verfahren: Empfehlungen und Schlüssellängen (German)](https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Publikationen/TechnischeRichtlinien/TR02102/BSI-TR-02102.pdf)
- [NIST - Hash Functions: Approved Algorithms](https://csrc.nist.gov/projects/hash-functions#approved-algorithms)
