Catching an exception by value or pointer is considered a bad practice, as it can be costly, lead to potential loss of information, or complicate memory management.
Prefer catching exceptions by reference to avoid these problems.

# What Does This Check Look For?

This check detects occurrences where exceptions are caught by value or pointer.

# Why is This a Problem?

Catching exceptions by value is less efficient because it involves copying the exception object, which might not only reduce performance but also result in the slicing problem when dealing with polymorphic exceptions.
This can lead to a loss of information that might be critical for error handling logic. 
Catching by pointer is also considered a bad practice.
Although no full copy of the exception object is created, it leaves the memory management to the catch block, which is suboptimal.

# How Can I Resolve This?

To resolve these issues, exceptions should be caught by reference. This practice
- eliminates the performance overhead of copying the exception object,
- prevents the slicing problem, preserving the full information about the exception, and
- simplifies memory management by automatically handling the exception object's lifecycle.

# Examples

## Non-Compliant

```cpp
try {
    throw DerivedException();
} catch (BaseException e) {  // non-compliant: catching by value
    // handle exception
} catch (BaseException* e) {  // non-compliant: catching by pointer
    // handle exception
}
```

## Compliant

```cpp
try {
    throw DerivedException();
} catch (BaseException& e) {  // compliant: catching by reference
    // handle exception
}
```

# Where Can I Learn More?

- [ISO C++ FAQ: Exceptions and Error Handling ](https://isocpp.org/wiki/faq/exceptions)