Improper assertions may go unnoticed or fail unexpectedly if not following the AssertJ library correctly.

Make sure you follow each `assertThat(...)` call with an assertion specification in the call chain. 
And if you use `.as(...)` to describe the assertion you should set it before calling the specified assertion in the chain.

# What Does This Check Look For?

This check reports a finding when an `assertThat(...)` call from AssertJ is not followed by an assertion specification in the call chain.

Additionally, if `.as(...)` is used as assertion descriptor:

* first, it does not count as a following assertion specification.
* second, it should be called before calling the specified assertion in the chain.

# Why is This a Problem?

The problem with not providing an assertion specification after an `assertThat(...)` call is that the `assertThat(...)` expression does not have any effect. 
It is important to provide an assertion specification to make the assertion meaningful and informative.

Also, `.as()` is not considered an assertion specification since it only works as an assertion descriptor.
Moreover, if the `.as()` call comes after the assertion it describes, it is going to be ignored since a failing assertion will prevent the call to `as()`.

# How Can I Resolve This?

To resolve this issue, make sure that every `assertThat(...)` call is followed by an assertion specification in the call chain. 
This ensures that the assertion is properly defined and meaningful. 
Also, the use of `as(...)` to describe assertion specifications is optional, but if used, it should come before the assertion it describes (never at the end).

# Examples
## Non-Compliant

```js
assertThat(list.isEmpty()); // missing assertion specification

assertThat(list).hasSize(5).as("This list should be size 5"); // .as(..) should not be the last method in the chain
```

## Compliant

```js
assertThat(list).isEmpty();
// or
assertThat(list.isEmpty()).isTrue();

assertThat(list).as("This list should be size 5").hasSize(5);
```

# Where Can I Learn More?

[AssertJ - fluent assertions java library](https://assertj.github.io/doc/)