The `goto` statement can easily lead to code that is very hard to read.
Loops or functions can help with removing it.

# What Does This Check Look For?

This check detects any use of the `goto` statement.


# Why is This a Problem?

Using the `goto` statement can easily lead to code that is very hard to read.
In some cases, it can even create unspecified behavior.

In PL/SQL, `goto` statements are also hard to format since they influence the logical structure of the code that should be represented by indentation.

## Exceptions

There is some code which becomes significantly more complex and harder to understand when avoiding the goto statement.
For these cases, making restricted use of the `goto` statement is sometimes advised.
One such example is the cleanup of allocated resources in C code.

If you would like to make limited use of the `goto` statement, but avoid the most error-prone constructs, we recommend allowing forward jumps only.

# How Can I Resolve This?

Backwards `goto`s can often be resolved by rewriting the code using a `for` or `while` loop.
In other cases, restructuring the code and using functions can work, as well.
In addition, breaking the code into smaller routines (`try`-`finally`, nested `if`) may also reduce the need for `goto` statements in the code.

# Where Can I Learn More?

## Guidelines

- [PL/SQL & SQL Coding Guidelines: G-4310: Never use GOTO statements in your code.](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.0/4-language-usage/4-control-structures/3-flow-control/g-4310/)
- Guideline: MISRA C:2012: 15.1 - The `goto` statement should not be used
- Guideline: AUTOSAR C++14, M6-6-1 - The goto statement shall not be used