This check detects appearances of the `inout` modifier for function parameters.

# Why is This a Problem?
The `inout` modifier indicates that a function argument is passed by reference instead of value.
This way, the function can modify the value of the given parameter outside the function's scope using its pointer.

Handling pointers correctly requires experience with pointers and reference types causing the usage of `out` parameters to be error-prone.

# How Can I Resolve This?
Instead of changing values outside the function with `out` parameters, one should use dedicated `return` values.

## Example (before)
```esql
CREATE FUNCTION NonCompliant(IN a INT, INOUT b INT) -- non compliant
BEGIN
    SET b = a + b; 
END;
```


## Example (after)
```esql
CREATE FUNCTION Compliant(IN a INT, IN b INT) -- compliant
BEGIN
    DECLARE result INTEGER;
    SET result = a + b;
    RETURN result;
END;
```
