/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.Arrays;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.enums.EnumUtils;

public class FlexiblePortPlacementParameters {
    public static final String EQUALLY_SPACED_RECT_CONNECTOR_PLACEMENT_TYPE = "ConnectorPlacement.EquallySpacedRectSide";
    public final EFlexiblePortPlacementSideName side;
    public final int portIndexOnSide;
    public final int totalNumberOfPortsOnSide;
    public final String connectorPlacementType;

    public FlexiblePortPlacementParameters(EFlexiblePortPlacementSideName side, int portIndexOnSide, int totalNumberOfPortsOnSide, String connectorPlacementType) {
        CCSMAssert.isTrue((portIndexOnSide < totalNumberOfPortsOnSide ? 1 : 0) != 0, () -> "port index on side " + portIndexOnSide + " is >= number of ports on that side (" + totalNumberOfPortsOnSide + ").");
        this.side = side;
        this.portIndexOnSide = portIndexOnSide;
        this.totalNumberOfPortsOnSide = totalNumberOfPortsOnSide;
        this.connectorPlacementType = connectorPlacementType;
    }

    public static enum EFlexiblePortPlacementSideName {
        LEFT(0),
        BOTTOM(90),
        RIGHT(180),
        TOP(270);

        public final int degreesCounterClockwiseFromLeft;

        private EFlexiblePortPlacementSideName(int degrees) {
            this.degreesCounterClockwiseFromLeft = degrees;
        }

        public static Optional<EFlexiblePortPlacementSideName> getSide(String sideNameInSimulink) {
            return Optional.ofNullable((EFlexiblePortPlacementSideName)EnumUtils.valueOf(EFlexiblePortPlacementSideName.class, (String)sideNameInSimulink));
        }

        public static Optional<EFlexiblePortPlacementSideName> getSideForAngle(int angleCounterClockwiseFromLeft) {
            return Arrays.stream(EFlexiblePortPlacementSideName.values()).filter(side -> side.degreesCounterClockwiseFromLeft == angleCounterClockwiseFromLeft).findAny();
        }
    }
}

