/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.StateLayoutData;
import org.conqat.lib.simulink.model.datahandler.stateflow.StateflowLayoutHandler;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;

public class StateflowState
extends StateflowNodeBase
implements IStateflowNodeContainer<IStateflowNodeContainer<?>>,
IStateflowChartContainer<IStateflowNodeContainer<?>> {
    public static final String DEFAULT_STATEFLOW_NODE_NAME = "?";
    private static final Pattern NAME_END_MATCHER = Pattern.compile("(\\\\r)|(\\\\n)|%");
    private final IdentityHashSet<StateflowNodeBase> nodes = new IdentityHashSet();
    private StateflowChart subviewer;

    public String getLabel() {
        return this.getParameter("labelString");
    }

    public String buildOwnQualifiedNameComponent() {
        String label = this.getLabel();
        if (label == null) {
            return this.getStateflowId();
        }
        String ownName = StateflowState.extractStateNameFromLabel(label);
        if (this.isSimulinkFunction() || this.isActionSubsystemState()) {
            ownName = this.getSimulinkBlock().getName();
        }
        if (this.isMatlabFunction() || this.isFunctionState()) {
            ownName = StateflowState.extractNameFromFunctionSignature(this.getLabel());
        }
        if (ownName.equals(DEFAULT_STATEFLOW_NODE_NAME) || ownName.isEmpty()) {
            return this.getStateflowId();
        }
        ownName = ownName.replace('/', '_');
        return ownName;
    }

    @Override
    public StateflowState findDirectChildStateByQualifiedNameComponent(String qualifiedNameComponent) {
        for (StateflowNodeBase child : this.nodes) {
            if (!(child instanceof StateflowState) || !((StateflowState)child).buildOwnQualifiedNameComponent().equals(qualifiedNameComponent)) continue;
            return (StateflowState)child;
        }
        return null;
    }

    private static String extractStateNameFromLabel(String label) {
        Matcher matcher = NAME_END_MATCHER.matcher(label);
        if (!matcher.find()) {
            return label.trim();
        }
        int nameEndIndex = matcher.start();
        return label.substring(0, nameEndIndex).trim();
    }

    static String extractNameFromFunctionSignature(String signature) {
        int nameStartIndex = signature.indexOf("=");
        nameStartIndex = nameStartIndex == -1 ? 0 : ++nameStartIndex;
        int nameEndIndex = signature.indexOf("(", nameStartIndex);
        if (nameEndIndex == -1) {
            nameEndIndex = signature.length();
        }
        return signature.substring(nameStartIndex, nameEndIndex).trim();
    }

    @Override
    public String buildQualifiedName() {
        String ownName = this.buildOwnQualifiedNameComponent();
        IStateflowNodeContainer parent = (IStateflowNodeContainer)this.getParent();
        String parentQualifiedName = parent.buildQualifiedName();
        if (parent instanceof StateflowChart) {
            return parentQualifiedName + "/" + ownName;
        }
        return parentQualifiedName + "." + ownName;
    }

    public void setSubViewer(StateflowChart subChart) {
        CCSMAssert.isTrue((this.subviewer == null ? 1 : 0) != 0, (String)"May not set subchart twice!");
        this.subviewer = subChart;
        this.subviewer.setParent(this);
    }

    public StateflowChart getSubViewer() {
        return this.subviewer;
    }

    @Override
    public UnmodifiableCollection<StateflowChart> getCharts() {
        if (this.subviewer == null) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(Collections.singleton(this.subviewer));
    }

    @Override
    public UnmodifiableCollection<StateflowChart> getCharts(boolean includeCommented) {
        boolean isCommented;
        if (this.subviewer == null) {
            return CollectionUtils.emptyList();
        }
        boolean bl = isCommented = "1".equals(this.subviewer.getParameter("comment.xplicit")) || "1".equals(this.getParameter("comment.xplicit"));
        if (isCommented) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(Collections.singleton(this.subviewer));
    }

    @Override
    public UnmodifiableSet<StateflowNodeBase> getNodes() {
        TreeSet<StateflowNodeBase> sortedNodes = new TreeSet<StateflowNodeBase>(Comparator.comparing(StateflowElementBase::getStateflowId));
        sortedNodes.addAll((Collection<StateflowNodeBase>)this.nodes);
        return CollectionUtils.asUnmodifiable(sortedNodes);
    }

    @Override
    public void addNode(StateflowNodeBase node) {
        this.nodes.add((Object)node);
        node.setParent(this);
    }

    void removeNode(StateflowNodeBase node) {
        CCSMAssert.isTrue((node.getParent() == this ? 1 : 0) != 0, (String)"Node does not belong to this chart.");
        this.nodes.remove((Object)node);
        node.setParent(null);
    }

    @Override
    @SimulinkTestExclude
    public StateLayoutData obtainLayoutData() {
        return StateflowLayoutHandler.obtainStateLayoutData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainLabelData() {
        return StateflowLayoutHandler.obtainStateLabelData(this);
    }

    public boolean isSubChart() {
        if (this.isSimulinkFunction() || this.isActionSubsystemState()) {
            return false;
        }
        return "SUBCHART".equals(this.getParameter("superState"));
    }

    public boolean isSubState() {
        String type = this.getParameter("type");
        return "OR_STATE".equals(type) || "AND_STATE".equals(type);
    }

    public boolean isFunctionState() {
        return "FUNC_STATE".equals(this.getParameter("type"));
    }

    public boolean isGroupState() {
        return "GROUP_STATE".equals(this.getParameter("type"));
    }

    public boolean isSimulinkFunction() {
        return "1".equals(this.getParameter("simulink.isSimulinkFcn"));
    }

    public boolean isMatlabFunction() {
        return "1".equals(this.getParameter("eml.isEML"));
    }

    public boolean isNoteBox() {
        return "1".equals(this.getParameter("isNoteBox"));
    }

    public boolean isAtomicSubChart() {
        return "1".equals(this.getParameter("simulink.isComponent"));
    }

    public boolean isActionSubsystemState() {
        return "1".equals(this.getParameter("simulink.isActionSubsystem"));
    }

    public boolean isRegularState() {
        String type = this.getParameter("type");
        return "OR_STATE".equals(type) || "AND_STATE".equals(type);
    }
}

