/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.IOException;
import java.util.Arrays;
import us.hebi.matlab.mat.types.AbstractCellBase;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.util.Preconditions;

public abstract class AbstractCell
extends AbstractCellBase {
    protected final Array[] contents;

    protected AbstractCell(int[] dims, Array[] values) {
        super(dims);
        Preconditions.checkArgument(values.length == this.getNumElements(), "invalid length");
        this.contents = values;
    }

    @Override
    public <T extends Array> T get(int index) {
        return (T)this.contents[index];
    }

    @Override
    public Cell set(int index, Array value) {
        this.contents[index] = value;
        return this;
    }

    protected abstract Array getEmptyValue();

    @Override
    public void close() throws IOException {
        for (Array array : this.contents) {
            array.close();
        }
        Arrays.fill(this.contents, this.getEmptyValue());
    }
}

