/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class AccountCredentials {
    public static final String GENERATE_ACCOUNT_PREFIX = "##generate-account##";
    private final String accountIdentifier;

    public AccountCredentials(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    public static ExternalCredentials createOptionsFromAutoGenerateIdentifier(String identifier, ExternalCredentialsIndex externalCredentialsIndex) throws StorageException {
        if (!identifier.startsWith(GENERATE_ACCOUNT_PREFIX)) {
            return null;
        }
        String url = StringUtils.stripPrefix((String)identifier, (String)GENERATE_ACCOUNT_PREFIX);
        ExternalCredentials externalCredentials = new ExternalCredentials(AccountCredentials.createUniqueIdentifierFromUrl(url, externalCredentialsIndex), url);
        externalCredentials.setLastChangeInformation("Teamscale (auto-created)", System.currentTimeMillis());
        externalCredentialsIndex.setExternalCredentials(externalCredentials);
        return externalCredentials;
    }

    private static String createUniqueIdentifierFromUrl(String url, IExternalCredentialsProvider credentialsProvider) throws StorageException {
        ExternalCredentials externalCredentials;
        String baseName = StringUtils.getLastPart((String)url, (char)'/');
        Object name = baseName;
        int counter = 1;
        while ((externalCredentials = credentialsProvider.getExternalCredentials((String)name)) != null || StringUtils.isEmpty((String)name)) {
            name = baseName + counter++;
        }
        return name;
    }

    public String toString() {
        return this.accountIdentifier;
    }

    public int hashCode() {
        return this.accountIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AccountCredentials && ((AccountCredentials)obj).accountIdentifier.equals(this.accountIdentifier);
    }
}

