/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.authenticate.base.SynchronizeGroupsStrategyBase;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.GlobalAnalysisProgressIndex;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

public abstract class SynchronizeGroupsAsyncStrategyBase<ServerDescription extends ServerDescriptionBase>
extends SynchronizeGroupsStrategyBase<ServerDescription> {
    public static final String SERVER_NAME_PARAMETER_NAME = "server-name";
    public static final String SERVER_TYPE_PARAMETER_NAME = "server-type";
    public static final String DELIMITER = ":";
    private final GlobalAnalysisProgressIndex progressIndex;

    protected SynchronizeGroupsAsyncStrategyBase(NamedServer<ServerDescription> server, UserIndex userIndex, UserGroupIndex groupIndex, GlobalAnalysisProgressIndex progressIndex, IImportGroupsStrategy importGroupsStrategy, IMessageBroker messageBroker) {
        super(server, userIndex, groupIndex, messageBroker, importGroupsStrategy);
        this.progressIndex = progressIndex;
    }

    @Override
    public void synchronizeSingleGroup(String groupName) throws AuthenticationToolException {
        try {
            String serverName = this.getServer().name();
            ISchedulerCommunicator.getInstance().scheduleExternalJob(this.progressIndex, this.messageBroker, JobDescriptor.createMaintenanceTriggerWithParameter(this.getTriggerClass(), serverName + DELIMITER + groupName, "Scheduled as user triggered group synchronization for server " + serverName + " and group " + groupName));
        }
        catch (StorageException e) {
            throw new AuthenticationToolException("Failed to schedule synchronization job!", e);
        }
    }

    @Override
    public List<String> synchronizeAllGroups() throws AuthenticationToolException {
        this.synchronizeSingleGroup("#ALL_GROUPS#");
        return Collections.emptyList();
    }

    protected abstract Class<? extends PrivilegedTriggerBase> getTriggerClass();
}

