/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.index;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="oauth-state", valueClasses={String.class})
public class OAuthStateIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "oauth-state";
    private static final Duration DEFAULT_EXPIRATION_MINUTES = Duration.ofMinutes(10L);
    private final ValueIndex<OAuthState> index;

    public OAuthStateIndex(IStore store) {
        this.index = ValueIndex.forSerializable((IStore)store);
    }

    public void storeState(String stateToken, String sessionId) throws StorageException {
        Instant expiration = Instant.now().plus(DEFAULT_EXPIRATION_MINUTES);
        long expirationDateInMilli = expiration.toEpochMilli();
        OAuthState state = new OAuthState(sessionId, expirationDateInMilli);
        this.index.setValue(stateToken, (Object)state);
    }

    public @Nullable String validateAndConsume(String stateToken) throws StorageException {
        OAuthState value = (OAuthState)this.index.getValue(stateToken);
        if (value == null) {
            return null;
        }
        this.index.removeValue(stateToken);
        if (DateTimeUtils.millisNow() > value.expirationDateInMillis) {
            return null;
        }
        return value.sessionId;
    }

    @IndexValueClass
    private record OAuthState(String sessionId, long expirationDateInMillis) implements Serializable
    {
    }
}

