/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.committree;

import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Stack;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public class CommitTreeNode
implements ICommitTreeNode {
    static final long NOT_SET = -1L;
    private final CommitTreeRevision revision;
    private final long originalTimestamp;
    private long adjustedTimestamp = -1L;
    private final List<CommitTreeNode> parents = new ArrayList<CommitTreeNode>();
    private List<CommitTreeNode> nonEmptyParents = null;
    private CommitDescriptor injectedParent;
    private ECommitTreeNodeState state = ECommitTreeNodeState.UNPROCESSED;
    private CommitTree commitTree;
    private final long discoveryTimestamp;
    private static final Logger LOGGER = LogManager.getLogger();

    public CommitTreeNode(CommitTreeRevision revision, long originalTimestamp, long discoveryTimestamp) {
        this.revision = revision;
        this.originalTimestamp = originalTimestamp;
        this.discoveryTimestamp = discoveryTimestamp;
    }

    public void addParent(CommitTreeNode parent) {
        CCSMAssert.isFalse((boolean)parent.getRevision().equals(this.revision), () -> "Parents may not contain revision: " + String.valueOf(this.revision) + " (Parent: " + String.valueOf(parent) + ")");
        this.parents.add(parent);
    }

    void forceLatestFirstParent() {
        for (int i = 1; i < this.parents.size(); ++i) {
            if (!this.parents.getFirst().getBranchName().equals(this.parents.get(i).getBranchName()) || this.parents.getFirst().getOriginalTimestamp() >= this.parents.get(i).getOriginalTimestamp()) continue;
            Collections.swap(this.parents, 0, i);
        }
    }

    @Override
    public CommitTreeRevision getRevision() {
        return this.revision;
    }

    @Override
    public String getBranchName() {
        return this.revision.getBranchName();
    }

    @Override
    public long getOriginalTimestamp() {
        return this.originalTimestamp;
    }

    protected void adopt(CommitTree commitTree) {
        CCSMAssert.isTrue((this.commitTree == null ? 1 : 0) != 0, (String)"May not adopt twice!");
        this.commitTree = commitTree;
    }

    public UnmodifiableList<CommitTreeNode> getParents() {
        return CollectionUtils.asUnmodifiable(this.parents);
    }

    @Override
    public List<CommitTreeRevision> getParentRevisions() {
        return CollectionUtils.map(this.parents, CommitTreeNode::getRevision);
    }

    private CommitTree accessCommitTree() throws AssertionError {
        CCSMAssert.isNotNull((Object)this.commitTree, (String)"Operation not support on isolated nodes!");
        return this.commitTree;
    }

    @Override
    public ECommitTreeNodeState getState() {
        return this.state;
    }

    void setStateUnchecked(ECommitTreeNodeState state) {
        this.state = state;
    }

    @Override
    public void copyState(ICommitTreeNode sourceNode) {
        this.setStateUnchecked(sourceNode.getState());
    }

    @Override
    public long getDiscoveryTimestamp() {
        return this.discoveryTimestamp;
    }

    void setAdjustedTimestamp(long adjustedTimestamp) {
        CCSMAssert.isTrue((adjustedTimestamp >= 0L ? 1 : 0) != 0, (String)"May not set adjusted timestamp to negative value!");
        this.adjustedTimestamp = adjustedTimestamp;
        this.accessCommitTree().updateAdjustment(this);
    }

    public List<CommitTreeNode> getNonEmptyParents() {
        CCSMAssert.isTrue((!ECommitTreeNodeState.isUnScheduledState(this.state) ? 1 : 0) != 0, () -> "Attempted to retrieve non-empty parents for node which is in an unscheduled state: " + String.valueOf(this));
        if (this.nonEmptyParents != null) {
            return this.nonEmptyParents;
        }
        ArrayList<CommitTreeNode> processedParents = new ArrayList<CommitTreeNode>();
        LinkedList<CommitTreeNode> nodesToProcess = new LinkedList<CommitTreeNode>(this.parents);
        IdentityHashSet seen = new IdentityHashSet(this.parents);
        block4: while (!nodesToProcess.isEmpty()) {
            CommitTreeNode current = (CommitTreeNode)nodesToProcess.poll();
            LOGGER.debug("Processing parent node {} with state {}", (Object)current.revision, (Object)current.getState());
            switch (current.getState()) {
                case EMPTY: 
                case SKIPPED: {
                    CollectionUtils.reverse(current.getParents()).stream().filter(((Set)seen)::add).forEach(nodesToProcess::push);
                    continue block4;
                }
                case PROCESSED: {
                    processedParents.add(current);
                    continue block4;
                }
            }
            CCSMAssert.fail((String)("May not receive non-empty parents of " + String.valueOf(this) + ", as there are non-processed parent nodes, such as " + String.valueOf(current) + "."));
        }
        List<CommitTreeNode> reducedParents = CommitTreeNode.eliminateTransitivelyDependentCommits(processedParents, this.revision.getBranchName(), this.getParents());
        this.nonEmptyParents = CommitTreeNode.recoverFromMultipleParentsFromSameBranch(reducedParents);
        CommitTreeNode.ensureSameBranchIsFirstParent(this.nonEmptyParents, this.revision.getBranchName());
        return this.nonEmptyParents;
    }

    private static void ensureSameBranchIsFirstParent(List<CommitTreeNode> nonEmptyParents, String branchOfCurrentNode) {
        OptionalInt indexOfParentOnSameBranch = IntStream.range(0, nonEmptyParents.size()).filter(i -> ((CommitTreeNode)nonEmptyParents.get(i)).getBranchName().equals(branchOfCurrentNode)).findFirst();
        if (indexOfParentOnSameBranch.isEmpty() || indexOfParentOnSameBranch.getAsInt() == 0) {
            return;
        }
        CommitTreeNode parentOnSameBranch = nonEmptyParents.get(indexOfParentOnSameBranch.getAsInt());
        nonEmptyParents.remove(indexOfParentOnSameBranch.getAsInt());
        nonEmptyParents.addFirst(parentOnSameBranch);
    }

    private static List<CommitTreeNode> recoverFromMultipleParentsFromSameBranch(List<CommitTreeNode> reducedParents) {
        long branchCount = reducedParents.stream().map(x -> x.getRevision().getBranchName()).distinct().count();
        if (branchCount < (long)reducedParents.size()) {
            LOGGER.error("Had multiple parents from same branch, which should not happen: {}", reducedParents);
            HashSet branches = new HashSet();
            reducedParents = CollectionUtils.filter(reducedParents, parent -> branches.add(parent.getRevision().getBranchName()));
            LOGGER.error("Continuing with reduced set: {}", (Object)reducedParents);
        }
        return reducedParents;
    }

    private static List<CommitTreeNode> eliminateTransitivelyDependentCommits(List<CommitTreeNode> nodes, String preserveBranchName, List<CommitTreeNode> originalParents) {
        if (nodes.isEmpty()) {
            return nodes;
        }
        long minAdjustedTimestamp = nodes.stream().mapToLong(node -> node.getAdjustedTimestamp().orElseThrow()).min().orElseThrow();
        HashSet<CommitTreeRevision> seenRevisions = new HashSet<CommitTreeRevision>();
        LinkedList<CommitTreeNode> toBeProcessed = new LinkedList<CommitTreeNode>(nodes);
        while (!toBeProcessed.isEmpty()) {
            CommitTreeNode node2 = (CommitTreeNode)toBeProcessed.poll();
            LOGGER.debug("Processing revision {} to eliminate transitively dependent commits", (Object)node2.revision);
            for (CommitTreeNode parent : node2.getParents()) {
                if (parent.getAdjustedTimestamp().orElseThrow() < minAdjustedTimestamp || !seenRevisions.add(parent.getRevision())) continue;
                toBeProcessed.add(parent);
            }
        }
        List result = CollectionUtils.filter(nodes, node -> seenRevisions.add(node.getRevision()));
        CommitTreeNode originalFirstParent = null;
        if (!originalParents.isEmpty()) {
            originalFirstParent = originalParents.getFirst();
        }
        CommitTreeNode.ensureCommitFromBranchIsPreserved(nodes, preserveBranchName, result, originalFirstParent);
        return result;
    }

    private static void ensureCommitFromBranchIsPreserved(List<CommitTreeNode> nodes, String preserveBranchName, List<CommitTreeNode> result, @Nullable CommitTreeNode originalFirstParent) {
        if (CommitTreeNode.streamOfNodesWithBranchName(preserveBranchName, result).findAny().isPresent()) {
            return;
        }
        Optional<CommitTreeNode> additionalParent = CommitTreeNode.streamOfNodesWithBranchName(preserveBranchName, nodes).max(Comparator.comparingLong(CommitTreeNode::getOriginalTimestamp));
        if (additionalParent.isPresent()) {
            result.addFirst(additionalParent.get());
        } else if (originalFirstParent != null && CommitTreeNode.streamOfNodesWithBranchName(originalFirstParent.getBranchName(), result).findAny().isEmpty() && nodes.contains(originalFirstParent)) {
            result.addFirst(originalFirstParent);
        }
    }

    private static Stream<CommitTreeNode> streamOfNodesWithBranchName(String branchName, List<CommitTreeNode> result) {
        return result.stream().filter(node -> node.getRevision().getBranchName().equals(branchName));
    }

    @Override
    public CommitDescriptor getAdjustedCommitDescriptor() {
        return new CommitDescriptor(this.revision.getBranchName(), this.adjustedTimestamp);
    }

    public boolean hasParents() {
        return !this.parents.isEmpty();
    }

    @Override
    public OptionalLong getAdjustedTimestamp() {
        if (this.adjustedTimestamp == -1L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this.adjustedTimestamp);
    }

    public void setAdjusted(long adjustedTimestamp) {
        CCSMAssert.isTrue((adjustedTimestamp >= 0L ? 1 : 0) != 0, (String)"May not set adjusted timestamp to negative value!");
        CCSMAssert.isTrue((this.state == ECommitTreeNodeState.UNPROCESSED ? 1 : 0) != 0, () -> "Attempted to set node to state ADJUSTED which is not in state UNPROCESSED: " + String.valueOf(this));
        this.adjustedTimestamp = adjustedTimestamp;
        this.state = ECommitTreeNodeState.ADJUSTED;
        this.accessCommitTree().updateAdjustment(this);
    }

    private void setStateChecked(ECommitTreeNodeState expectedState, ECommitTreeNodeState newState) {
        CCSMAssert.isTrue((this.state == expectedState ? 1 : 0) != 0, () -> "Attempted to set node to state " + String.valueOf((Object)newState) + " which is not in state " + String.valueOf((Object)expectedState) + ": " + String.valueOf(this));
        this.state = newState;
    }

    public void setSkipped() {
        CCSMAssert.isTrue((boolean)this.isSchedulable(), () -> "Attempted to skip node which has unprocessed parents: " + String.valueOf(this));
        this.setStateChecked(ECommitTreeNodeState.ADJUSTED, ECommitTreeNodeState.SKIPPED);
    }

    public void setScheduled() {
        CCSMAssert.isTrue((boolean)this.isSchedulable(), () -> "Attempted to set node to state SCHEDULED which is not schedulable: " + String.valueOf(this));
        this.setStateChecked(ECommitTreeNodeState.ADJUSTED, ECommitTreeNodeState.SCHEDULED);
    }

    public void setEmpty() {
        this.setStateChecked(ECommitTreeNodeState.SCHEDULED, ECommitTreeNodeState.EMPTY);
    }

    public void setProcessed() {
        this.setStateChecked(ECommitTreeNodeState.SCHEDULED, ECommitTreeNodeState.PROCESSED);
    }

    public void resetScheduledNode() {
        CCSMAssert.isTrue((this.state == ECommitTreeNodeState.SCHEDULED ? 1 : 0) != 0, (String)"Can only reset scheduled node.");
        this.setStateChecked(ECommitTreeNodeState.SCHEDULED, ECommitTreeNodeState.ADJUSTED);
    }

    public boolean hasUnprocessedParents() {
        return !CollectionUtils.allMatch(this.getParents(), CommitTreeNode::isProcessedOrEmptyOrSkipped);
    }

    public boolean isSchedulable() {
        if (this.state != ECommitTreeNodeState.ADJUSTED) {
            return false;
        }
        return CommitTreeNode.hasOnlyProcessedAndEmptyParentsRecursively(this);
    }

    public boolean isPreAnnounceable() {
        if (this.state != ECommitTreeNodeState.ADJUSTED) {
            return false;
        }
        return this.isForkCommit() || this.parents.size() > 1 && CommitTreeNode.hasAnyProcessedOrEmptyParent(this);
    }

    private boolean isForkCommit() {
        String branchName = this.revision.getBranchName();
        return CollectionUtils.allMatch(this.parents, parent -> !parent.getRevision().getBranchName().equals(branchName));
    }

    private static boolean hasOnlyProcessedAndEmptyParentsRecursively(CommitTreeNode node) {
        HashSet seenNodes = new HashSet();
        Stack<CommitTreeNode> parentsToCheck = new Stack<CommitTreeNode>();
        parentsToCheck.addAll((Collection<CommitTreeNode>)node.getParents());
        while (!parentsToCheck.isEmpty()) {
            CommitTreeNode parent = (CommitTreeNode)parentsToCheck.pop();
            if (parent.getState() == ECommitTreeNodeState.SKIPPED) {
                CommitTreeNode.addElementsToCollectionIfNotInSet(parent.getParents(), parentsToCheck, seenNodes);
                continue;
            }
            if (parent.isProcessedOrEmpty()) continue;
            return false;
        }
        return true;
    }

    private static <T> void addElementsToCollectionIfNotInSet(List<T> elementsToAdd, Collection<T> destinationList, Set<T> checkSet) {
        for (T element : elementsToAdd) {
            if (!checkSet.add(element)) continue;
            destinationList.add(element);
        }
    }

    private static boolean hasAnyProcessedOrEmptyParent(CommitTreeNode node) {
        HashSet seenNodes = new HashSet();
        Stack<CommitTreeNode> parentsToCheck = new Stack<CommitTreeNode>();
        parentsToCheck.addAll((Collection<CommitTreeNode>)node.getParents());
        while (!parentsToCheck.isEmpty()) {
            CommitTreeNode parent = (CommitTreeNode)parentsToCheck.pop();
            if (parent.getState() == ECommitTreeNodeState.SKIPPED) {
                CommitTreeNode.addElementsToCollectionIfNotInSet(parent.getParents(), parentsToCheck, seenNodes);
                continue;
            }
            if (!parent.isProcessedOrEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentOnOtherBranch() {
        String branchName = this.revision.getBranchName();
        return CollectionUtils.anyMatch(this.parents, parent -> !parent.getRevision().getBranchName().equals(branchName));
    }

    private boolean isProcessedOrEmptyOrSkipped() {
        return ECommitTreeNodeState.isProcessedState(this.state);
    }

    private boolean isProcessedOrEmpty() {
        return this.state == ECommitTreeNodeState.PROCESSED || this.state == ECommitTreeNodeState.EMPTY;
    }

    public CommitDescriptor getInjectedParent() {
        return this.injectedParent;
    }

    void setInjectedParent(CommitDescriptor injectedParent) {
        this.injectedParent = injectedParent;
    }

    public String toString() {
        return "CommitTreeNode [revision=" + String.valueOf(this.revision) + ", originalTimestamp=" + this.originalTimestamp + ", adjustedTimestamp=" + this.adjustedTimestamp + ", parentRevisions=" + String.valueOf(this.getParentRevisions()) + ", state=" + String.valueOf((Object)this.state) + "]";
    }
}

