/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.config;

import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.config.DistributionConfiguration;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.rest.EHttpMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.ConfigurationException;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class ServerConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TEAMSCALE_PROPERTIES_ENV_VARIABLE_NAME = "TS_PROPERTIES";
    private static final String HTTP_PORT_KEY = "server.port";
    private static final int DEFAULT_HTTP_PORT = 8080;
    private static final String URL_PREFIX_KEY = "server.urlprefix";
    private static final String DEFAULT_URL_PREFIX = "";
    private static final String HOSTNAME_KEY = "server.bind-hostname";
    private static final String CUSTOM_CHECK_DIRECTORY_KEY = "custom-checks.dir";
    private static final String DEFAULT_CUSTOM_CHECK_DIRECTORY = "custom-checks";
    private static final String NUM_WORKERS_KEY = "engine.workers";
    private static final String DEFAULT_NUM_WORKERS = "4";
    private static final ELogLevel DEFAULT_SERVICE_LOGLEVEL = ELogLevel.WARN;
    private static final String SERVICELOG_LOGLEVEL = "servicelog.loglevel";
    private static final String SERVICELOG_LOGUSER = "servicelog.loguser";
    private static final String SERVICELOG_LOGIP = "servicelog.logip";
    private static final String HTTPS_PORT_KEY = "https.port";
    private static final String HTTPS_KEYSTORE_PATH_KEY = "https.keystore-path";
    private static final String HTTPS_KEYSTORE_PASSWORD_KEY = "https.keystore-password";
    private static final String HTTPS_CERTIFICATE_ALIAS_KEY = "https.certificate-alias";
    private static final String INSTANCE_NAME_KEY = "instance.name";
    private static final String DEFAULT_INSTANCE_NAME = "";
    public static final int DISABLED_PORT = 0;
    private int numWorkers;
    private File customChecksDirectory;
    private String hostname;
    private int httpPort;
    private int httpsPort;
    private String keyStorePath;
    private String keyStorePassword;
    private String certificateAlias;
    private String instanceName;
    private String urlPrefix;
    private ELogLevel serviceLogLevel;
    private boolean serviceLogIncludeUsers;
    private boolean serviceLogIncludeIp;
    private DatabaseConfiguration databaseConfiguration;
    private DistributionConfiguration distributionConfiguration;
    private CorsConfiguration corsConfiguration = CorsConfiguration.loadFromSystemProperties();

    private ServerConfiguration() {
    }

    public static ServerConfiguration loadFromPropertiesFile(File propertiesFile) throws IOException, ConfigurationException {
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            ServerConfiguration serverConfiguration = ServerConfiguration.createFromProperties(ServerConfiguration.safeLoadProperties(inputStream));
            return serverConfiguration;
        }
    }

    @VisibleForTesting
    static Properties safeLoadProperties(InputStream inputStream) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String line : StringUtils.splitLinesAsList((String)FileSystemUtils.readStreamUTF8((InputStream)inputStream))) {
            if (!line.startsWith("#") && ServerConfiguration.needsBackslashesEscaped(line)) {
                line = line.replace("\\", "\\\\");
            }
            builder.append(line).append("\n");
        }
        Properties properties = new Properties();
        properties.load(new StringReader(builder.toString()));
        return properties;
    }

    private static boolean needsBackslashesEscaped(String line) {
        if (line.contains("\\\\")) {
            return false;
        }
        if (line.matches(".*[a-zA-Z]:\\\\.*")) {
            return true;
        }
        return line.matches(".*[a-zA-Z]\\\\[a-zA-Z].*");
    }

    public static ServerConfiguration defaultConfiguration() throws ConfigurationException {
        return ServerConfiguration.createFromProperties(new Properties());
    }

    public static ServerConfiguration defaultConfigurationWithPort(int port) throws ConfigurationException {
        Properties properties = new Properties();
        properties.setProperty(HTTP_PORT_KEY, "" + port);
        return ServerConfiguration.createFromProperties(properties);
    }

    public static ServerConfiguration defaultConfigurationWithInstanceNameAndPort(String instanceName, int port) throws ConfigurationException {
        Properties properties = new Properties();
        properties.setProperty(INSTANCE_NAME_KEY, instanceName);
        properties.setProperty(HTTP_PORT_KEY, "" + port);
        return ServerConfiguration.createFromProperties(properties);
    }

    private static ServerConfiguration createFromProperties(Properties properties) throws ConfigurationException {
        ServerConfiguration config = new ServerConfiguration();
        String environmentProperties = System.getenv(TEAMSCALE_PROPERTIES_ENV_VARIABLE_NAME);
        if (environmentProperties != null) {
            try {
                properties.load(StringUtils.toInputStream((String)environmentProperties));
            }
            catch (IOException e) {
                LOGGER.error("Could not load properties from $TS_PROPERTIES.", (Throwable)e);
            }
        }
        config.initBasicServerSettings(properties);
        config.databaseConfiguration = DatabaseConfiguration.readFromProperties((Properties)properties);
        config.distributionConfiguration = DistributionConfiguration.readFromProperties(properties);
        config.initLogging(properties);
        return config;
    }

    private void initBasicServerSettings(Properties properties) throws ConfigurationException {
        this.httpPort = ServerConfiguration.extractPort(properties, HTTP_PORT_KEY, 8080);
        this.httpsPort = ServerConfiguration.extractPort(properties, HTTPS_PORT_KEY, 0);
        if (this.isHttpsConfigured()) {
            this.keyStorePath = ServerConfiguration.extractStringParameter(properties, HTTPS_KEYSTORE_PATH_KEY);
            this.keyStorePassword = ServerConfiguration.extractStringParameter(properties, HTTPS_KEYSTORE_PASSWORD_KEY);
            this.certificateAlias = ServerConfiguration.extractStringParameter(properties, HTTPS_CERTIFICATE_ALIAS_KEY);
        }
        if (!this.isHttpConfigured() && !this.isHttpsConfigured()) {
            throw new ConfigurationException("Must either set server.port or https.port");
        }
        this.customChecksDirectory = TeamscaleInstallationUtils.getRootPath((String)properties.getProperty(CUSTOM_CHECK_DIRECTORY_KEY, DEFAULT_CUSTOM_CHECK_DIRECTORY)).toFile();
        this.urlPrefix = properties.getProperty(URL_PREFIX_KEY, "");
        this.hostname = properties.getProperty(HOSTNAME_KEY);
        this.numWorkers = DatabaseConfiguration.extractIntegerParameter((Properties)properties, (String)NUM_WORKERS_KEY, (String)DEFAULT_NUM_WORKERS);
        this.instanceName = properties.getProperty(INSTANCE_NAME_KEY, "");
    }

    private static String extractStringParameter(Properties properties, String key) throws ConfigurationException {
        String value = properties.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            throw new ConfigurationException("Expected non-empty value for: " + key);
        }
        return value;
    }

    private void initLogging(Properties properties) {
        String logLevelProperty = properties.getProperty(SERVICELOG_LOGLEVEL, DEFAULT_SERVICE_LOGLEVEL.name());
        this.serviceLogLevel = (ELogLevel)EnumUtils.valueOfIgnoreCase(ELogLevel.class, (String)logLevelProperty);
        if (this.serviceLogLevel == null) {
            throw new IllegalArgumentException("Unknown log level: " + logLevelProperty);
        }
        this.serviceLogIncludeUsers = Boolean.parseBoolean(properties.getProperty(SERVICELOG_LOGUSER, "false"));
        this.serviceLogIncludeIp = Boolean.parseBoolean(properties.getProperty(SERVICELOG_LOGIP, "false"));
    }

    private static int extractPort(Properties properties, String key, int defaultPort) throws ConfigurationException {
        int port = DatabaseConfiguration.extractIntegerParameter((Properties)properties, (String)key, (String)String.valueOf(defaultPort));
        if (port < 0 || port >= 65536) {
            throw new ConfigurationException("Invalid port: " + port);
        }
        return port;
    }

    public void logConfigSettings() {
        String bindHostname;
        LOGGER.info("Using URL prefix: '" + this.getUrlPrefix() + "'");
        if (this.isHttpConfigured()) {
            LOGGER.info("HTTP enabled. Port: " + this.httpPort);
        }
        if (this.isHttpsConfigured()) {
            LOGGER.info("HTTPS enabled. Port: " + this.httpsPort);
            LOGGER.info("Using Java keystore " + this.keyStorePath);
            LOGGER.info("Using certificate alias " + this.certificateAlias);
        }
        if ((bindHostname = this.getBindHostname()) != null) {
            LOGGER.info("Binding to hostname: " + bindHostname);
        }
        this.databaseConfiguration.logConfigSettings();
        LOGGER.info("Using " + this.getNumWorkers() + " workers");
        LOGGER.info("Using custom checks directory " + String.valueOf(this.getCustomChecksDirectory()));
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.databaseConfiguration;
    }

    public DistributionConfiguration getDistributionConfiguration() {
        return this.distributionConfiguration;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public File getCustomChecksDirectory() {
        return this.customChecksDirectory;
    }

    public String getBindHostname() {
        return this.hostname;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public ELogLevel getServiceLogLevel() {
        return this.serviceLogLevel;
    }

    public boolean isServiceLogIncludeUsers() {
        return this.serviceLogIncludeUsers;
    }

    public boolean isServiceLogIncludeIp() {
        return this.serviceLogIncludeIp;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isHttpConfigured() {
        return this.httpPort != 0;
    }

    public boolean isHttpsConfigured() {
        return this.httpsPort != 0;
    }

    public CorsConfiguration getCorsConfiguration() {
        return this.corsConfiguration;
    }

    @VisibleForTesting
    public void setCorsConfiguration(CorsConfiguration corsConfiguration) {
        CCSMAssert.isNotNull((Object)corsConfiguration, () -> String.format("Expected \"%s\" to be not null", "corsConfiguration"));
        this.corsConfiguration = corsConfiguration;
    }

    public InstanceConfiguration toInstanceConfiguration() {
        return new InstanceConfiguration(this.httpPort, this.httpsPort, this.instanceName, this.urlPrefix, this.databaseConfiguration);
    }

    public KeyStore loadHttpsKeyStore() throws IOException {
        KeyStore keyStore;
        File keyStoreFile = new File(FileSystemUtils.normalizeSeparators((String)this.getKeyStorePath()));
        if (!keyStoreFile.canRead()) {
            throw new IOException("Keystore file does not exist or is not readable: " + String.valueOf(keyStoreFile));
        }
        FileInputStream inputStream = new FileInputStream(keyStoreFile);
        try {
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(inputStream, this.getKeyStorePassword().toCharArray());
            String certificateAlias = this.getCertificateAlias();
            if (!keyStore2.containsAlias(certificateAlias)) {
                throw new IOException("Keystore " + String.valueOf(keyStoreFile) + " does not contain specified alias: " + certificateAlias);
            }
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Failed to read keystore. One possible reason could be, that the keystore was created with a different (likely newer) Java version than this instance is using. Current Java version: " + System.getProperty("java.version"), e);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        ((InputStream)inputStream).close();
        return keyStore;
    }

    public record CorsConfiguration(Set<Pattern> allowedOrigins, Set<String> allowedHeaders, Set<String> allowedMethods, boolean allowCredentials) {
        private static final UnmodifiableSet<String> ALLOWED_METHODS_DEFAULT = CollectionUtils.asUnmodifiable(Stream.of(EHttpMethod.GET, EHttpMethod.POST, EHttpMethod.HEAD).map(Object::toString).collect(Collectors.toSet()));
        private static final UnmodifiableSet<Pattern> ALLOWED_ORIGINS_DEFAULT = CollectionUtils.asUnmodifiable(Collections.emptySet());
        private static final UnmodifiableSet<String> ALLOWED_HEADERS_DEFAULT = CollectionUtils.asUnmodifiable(Set.of("X-Requested-With", "Content-Type", "Accept", "Origin"));
        private static final boolean ALLOW_CREDENTIALS_DEFAULT = true;

        @VisibleForTesting
        public CorsConfiguration {
            allowedOrigins = CollectionUtils.asUnmodifiable(allowedOrigins);
            allowedHeaders = CollectionUtils.asUnmodifiable(allowedHeaders);
            allowedMethods = CollectionUtils.asUnmodifiable(allowedMethods);
        }

        private static CorsConfiguration loadFromSystemProperties() {
            Set<Pattern> allowedOrigins = CorsConfiguration.getProperty("com.teamscale.server.cors.allowed-origins", ALLOWED_ORIGINS_DEFAULT, CorsConfiguration::parseAllowedWildcardOriginToRegex);
            Set<String> allowedHeaders = CorsConfiguration.getProperty("com.teamscale.server.cors.allowed-headers", ALLOWED_HEADERS_DEFAULT);
            Set<String> allowedMethods = CorsConfiguration.getProperty("com.teamscale.server.cors.allowed-methods", ALLOWED_METHODS_DEFAULT);
            boolean allowCredentials = Boolean.parseBoolean(System.getProperty("com.teamscale.server.cors.allow-credentials", Boolean.toString(true)));
            return new CorsConfiguration(allowedOrigins, allowedHeaders, allowedMethods, allowCredentials);
        }

        private static Set<String> getProperty(String key, Set<String> fallback) {
            return CorsConfiguration.getProperty(key, fallback, Function.identity());
        }

        private static <T> Set<T> getProperty(String key, Set<T> fallback, Function<? super String, ? extends T> mapper) {
            String value = System.getProperty(key);
            if (value == null) {
                return fallback;
            }
            return Arrays.stream(value.split(",")).map(mapper).collect(Collectors.toSet());
        }

        private static Pattern parseAllowedWildcardOriginToRegex(String allowedOrigin) {
            if (!allowedOrigin.contains("*")) {
                return Pattern.compile(Pattern.quote(allowedOrigin));
            }
            return Pattern.compile(allowedOrigin.replace(".", "\\.").replace("*", ".*"));
        }

        public static CorsConfiguration defaultConfiguration() {
            return new CorsConfiguration((Set<Pattern>)ALLOWED_ORIGINS_DEFAULT, (Set<String>)ALLOWED_HEADERS_DEFAULT, (Set<String>)ALLOWED_METHODS_DEFAULT, true);
        }
    }
}

