/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.mail;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.mail.HTMLValidator;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="custom.mail.option", name="Custom Mail Templates", type=EOptionType.SERVER, category=EOptionCategory.EMAIL, orderingHint=500)
@IndexValueClass(containedInBackup=true)
public class CustomMailOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "custom.mail.option";
    public static final String OPTION_NAME = "Custom Mail Templates";
    @JsonProperty(value="header")
    @MultilineOption
    @OptionFieldDescription(name="The HTML header that will be appended to the beginning of each e-mail")
    public String header = "";
    @JsonProperty(value="footer")
    @MultilineOption
    @OptionFieldDescription(name="The HTML footer that will be appended to the end of each e-mail")
    public String footer = "";

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (!HTMLValidator.validate(this.header)) {
            return "The custom header contains invalid HTML code.";
        }
        if (!HTMLValidator.validate(this.footer)) {
            return "The custom footer contains invalid HTML code.";
        }
        return null;
    }
}

