/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-abap-procedural-programming-check", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ProceduralProgrammingCheck
extends CheckImplementationBase {
    @CheckOption(name="Show FORM findings", description="Show findings for subroutines defined by the FORM keyword.")
    private boolean showFormFindings = true;
    @CheckOption(name="Show non-RFC FUNCTION findings", description="Show findings for non-RFC function modules defined by the FUNCTION keyword.")
    private boolean showFunctionFindings = true;

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!"form".equals(method.getSubtype()) && !"function".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (entity.getSubtype().equals("form") && this.showFormFindings) {
            this.buildFinding("Use object-oriented alternative instead of the procedural FORM", this.buildLocation().forTokens((List)entity.ownStartTokens())).createAndStore();
        } else if (entity.getSubtype().equals("function") && !AbapCheckUtils.isRfcEnabled((ICheckContext)this.context) && this.showFunctionFindings) {
            this.buildFinding("Use object-oriented alternative instead of the procedural FUNCTION", this.buildLocation().forTokens((List)entity.ownStartTokens())).createAndStore();
        }
    }
}

