/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-method-pairs-are-called", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MethodPairsAreCalledCheck
extends CheckImplementationBase {
    @CheckOption(name="List of method pairs that must be called in the same class", description="List of methods that must be called within class and should be paired with delete methods. For each of the given method pairs, if the given first method is called in a class, the given method must be also called in the same class. The first and the second method must be separated with the colon. Each method pair must be separated with the comma. An example pattern of defining the method pairs: first_method_name : second_method_name, third_method_name : fourth_method_name, \u2026 ")
    private String userDefinedMethodPairs = "getAddedOrChangedKeys : getDeletedKeys, getAddedOrChangedKeysAsStrings : getDeletedKeysAsStrings";
    static final String NAME = "Ensure method pairs are called";
    private static final String CHECK_OPTION_NAME = "List of method pairs that must be called in the same class";
    private static final String CHECK_OPTION_DESCRIPTION = "List of methods that must be called within class and should be paired with delete methods. For each of the given method pairs, if the given first method is called in a class, the given method must be also called in the same class. The first and the second method must be separated with the colon. Each method pair must be separated with the comma. An example pattern of defining the method pairs: first_method_name : second_method_name, third_method_name : fourth_method_name, \u2026 ";
    private static final Predicate<String> VALIDATION_PATTERN = Pattern.compile("(\\w+\\s*:\\s*\\w+){1}(\\s*,\\s*\\w+\\s*:\\s*\\w+)*").asMatchPredicate();
    private static final Pattern PAIR_PATTERN = Pattern.compile("(\\w+\\s*:\\s*\\w+)");

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (this.userDefinedMethodPairs.isEmpty() || !VALIDATION_PATTERN.test(this.userDefinedMethodPairs)) {
            return;
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entity.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT);
        if (statements.isEmpty()) {
            return;
        }
        HashMap<String, String> methodPairs = this.extractMethodPairs();
        if (methodPairs.isEmpty()) {
            return;
        }
        List allTokens = statements.stream().map(ShallowEntity::ownStartTokens).flatMap(Collection::stream).collect(Collectors.toList());
        List methodCallTokens = TokenStreamUtils.firstTokenOfTypeSequences(allTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).stream().map(index -> (IToken)allTokens.get((int)index)).collect(Collectors.toList());
        Set secondMethodsOfPairs = methodCallTokens.stream().map(IToken::getText).filter(tokenText -> methodPairs.containsValue(tokenText)).collect(Collectors.toSet());
        Predicate<IToken> containsFirstMethodNameToken = token -> methodPairs.containsKey(token.getText());
        Predicate<IToken> notContainsSecondMethodNameToken = token -> !secondMethodsOfPairs.contains(methodPairs.get(token.getText()));
        List methodTokensWithoutPair = methodCallTokens.stream().filter(containsFirstMethodNameToken).filter(notContainsSecondMethodNameToken).collect(Collectors.toList());
        for (IToken methodTokenWithoutPair : methodTokensWithoutPair) {
            this.buildFinding(this.getFindingMessage(methodPairs, methodTokenWithoutPair), this.buildLocation().forToken(methodTokenWithoutPair)).createAndStore();
        }
    }

    private HashMap<String, String> extractMethodPairs() {
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher matcher = PAIR_PATTERN.matcher(this.userDefinedMethodPairs);
        while (matcher.find()) {
            String[] splittedMethodPair = StringUtils.removeWhitespace((String)matcher.group()).split(":");
            if (splittedMethodPair.length != 2) continue;
            result.put(splittedMethodPair[0], splittedMethodPair[1]);
        }
        return result;
    }

    private String getFindingMessage(HashMap<String, String> methodPairs, IToken singlePair) {
        return "`" + singlePair.getText() + "` has been called, but `" + methodPairs.get(singlePair.getText()) + "` has not been called";
    }
}

