/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="java:S5679", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class OpenSAML2AuthenticationBypassCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Change `setIgnoreComments` to `true` or remove the call to `setIgnoreComments` to prevent the authentication bypass";
    private static final Set<String> TYPES = Set.of("StaticBasicParserPool", "BasicParserPool");
    private static final String IGNORE_COMMENTS_METHOD = "setIgnoreComments";
    private static final TokenPattern METHOD_CALL_ON_INSTANCE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setIgnoreComments"})})}).group(1).sequence(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.RPAREN}).group(2);
    private static final TokenPattern METHOD_CALL_ON_CONSTRUCTOR_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.NEW, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])TYPES.toArray(new String[0]))}), ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.RPAREN}).group(1);

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ITypeResolution typeResolution = this.context.getTypeResolution(this.getCodeViewOption());
        if (ast.isEmpty() || !OpenSAML2AuthenticationBypassCheck.hasOpenSAML2Import((ShallowEntity)ast.getFirst(), typeResolution)) {
            return;
        }
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            if (!OpenSAML2AuthenticationBypassCheck.isUnsafeMethodCallsOnInstance(statement, typeResolution) && !OpenSAML2AuthenticationBypassCheck.isUnsafeMethodCallsOnConstructor(statement)) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private static boolean hasOpenSAML2Import(ShallowEntity entity, ITypeResolution typeResolution) {
        Set importedNamespaces = typeResolution.getTypeLookup(entity).getImportedNamespaces();
        return importedNamespaces.stream().anyMatch(e -> e.startsWith("org.opensaml.xml"));
    }

    private static boolean isUnsafeMethodCallsOnInstance(ShallowEntity statement, ITypeResolution typeResolution) {
        ScopedTypeLookup typeLookup = typeResolution.getTypeLookup(statement);
        List nonOverlappingMatches = METHOD_CALL_ON_INSTANCE_PATTERN.findNonOverlappingMatches((List)statement.ownStartTokens());
        for (TokenPatternMatch match : nonOverlappingMatches) {
            String variable = (String)match.groupTexts(0).getFirst();
            TypedVariable typeInfo = typeLookup.getTypeInfo(variable);
            List<IToken> parameter = OpenSAML2AuthenticationBypassCheck.getTokensBetweenGroups(match, statement, 1, 2);
            if (!OpenSAML2AuthenticationBypassCheck.isUnsafeMethodCallsParserPool(typeInfo.getTypeName(), parameter)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnsafeMethodCallsParserPool(String typeName, List<IToken> parameter) {
        return TYPES.contains(typeName) && OpenSAML2AuthenticationBypassCheck.representFalse(parameter);
    }

    private static boolean isUnsafeMethodCallsOnConstructor(ShallowEntity statement) {
        List nonOverlappingMatches = METHOD_CALL_ON_CONSTRUCTOR_PATTERN.findNonOverlappingMatches((List)statement.ownStartTokens());
        for (TokenPatternMatch match : nonOverlappingMatches) {
            String methodName = (String)match.groupTexts(0).getFirst();
            List<IToken> parameter = OpenSAML2AuthenticationBypassCheck.getTokensBetweenGroups(match, statement, 0, 1);
            if (!methodName.equals(IGNORE_COMMENTS_METHOD) || !OpenSAML2AuthenticationBypassCheck.representFalse(parameter)) continue;
            return true;
        }
        return false;
    }

    private static List<IToken> getTokensBetweenGroups(TokenPatternMatch match, ShallowEntity statement, int firstGroup, int secondGroup) {
        int last = (Integer)match.groupIndices(firstGroup).getLast() + 2;
        int first = (Integer)match.groupIndices(secondGroup).getFirst();
        return statement.ownStartTokens().subList(last, first);
    }

    private static boolean representFalse(List<IToken> tokens) {
        IToken token;
        if (tokens.size() == 1 && (token = tokens.getFirst()).getType() == ETokenType.BOOLEAN_LITERAL && token.getText().equals("false")) {
            return true;
        }
        return tokens.size() == 3 && TokenStreamTextUtils.concatTokenTexts(tokens).equals("Boolean.FALSE");
    }
}

