/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-unnecessary-super-constructor-call", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnnecessarySuperConstructorCallCheck
extends CheckImplementationBase {
    private static final ETokenType[] PARAMETERLESS_SUPER_CONSTRUCTOR_CALL_SEQUENCE = new ETokenType[]{ETokenType.SUPER, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.SEMICOLON};

    public void execute() throws CheckException {
        List constructors = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.METHOD), Set.of("constructor"));
        for (ShallowEntity method : constructors) {
            this.processConstructor(method);
        }
    }

    private void processConstructor(ShallowEntity constructor) throws CheckException {
        for (ShallowEntity child : constructor.getChildren()) {
            if (child.getType() != EShallowEntityType.STATEMENT) continue;
            this.processEntity(child);
            return;
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList firstStatement = entity.includedTokens();
        if (firstStatement.size() != PARAMETERLESS_SUPER_CONSTRUCTOR_CALL_SEQUENCE.length) {
            return;
        }
        if (TokenStreamUtils.containsSequence((List)firstStatement, (int)0, (int)PARAMETERLESS_SUPER_CONSTRUCTOR_CALL_SEQUENCE.length, (ITokenMatcher[])PARAMETERLESS_SUPER_CONSTRUCTOR_CALL_SEQUENCE)) {
            this.buildFinding("Unnecessary parameterless super constructor call", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

