/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import java.util.Set;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class AssertJUtils {
    private static final Set<String> ASSERTION_DESCRIPTION_METHODS = Set.of("as", "describedAs", "overridingErrorMessage", "withFailMessage", "withRepresentation", "withThreadDumpOnError");
    private static final Set<String> ASSERTION_TRANSFORMATION_METHODS = Set.of("extracting", "filteredOn", "filteredOnAssertions", "filteredOnNull", "atIndex", "first", "last", "element", "asInstanceOf", "map", "flatMap", "returns");
    private static final Set<String> FLUENT_ASSERTION_PREDICATES = Set.of("is", "has", "contains", "does", "starts", "ends", "satisfies", "assignableFrom");

    static boolean isStartAssertionMethodName(String methodName) {
        return methodName.startsWith("assertThat") || methodName.equals("then") || methodName.equals("given");
    }

    static boolean isFluentAssertionMethodName(String methodName) {
        return FLUENT_ASSERTION_PREDICATES.stream().anyMatch(methodName::startsWith);
    }

    static boolean isAssertionDescriptionMethod(String methodName) {
        return ASSERTION_DESCRIPTION_METHODS.contains(methodName);
    }

    static boolean isAssertionTransformationMethod(String methodName) {
        return ASSERTION_TRANSFORMATION_METHODS.contains(methodName) || methodName.startsWith("using");
    }

    private AssertJUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

