/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PythonImportExtractor {
    private static final String IMPORT_ENTITY_XPATH = "//META[subtype('import') | subtype('from')]";
    private static final TokenPattern IMPORT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IMPORT}).repeatedAtLeastOnce(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(1).optional(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.AS, ETokenType.IDENTIFIER})}).optional(new Object[]{ETokenType.COMMA})});
    private static final TokenPattern FROM_IMPORT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.FROM}).sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(0).sequence(new Object[]{IMPORT_PATTERN});

    public static ListMap<String, ShallowEntity> extractImports(ShallowEntity rootEntity) throws CheckException {
        ListMap imports = new ListMap();
        for (ShallowEntity importEntity : CheckImplementationBase.select((ShallowEntity)rootEntity, (String)IMPORT_ENTITY_XPATH)) {
            PythonImportExtractor.extractFromImportEntity(importEntity, (ListMap<String, ShallowEntity>)imports);
        }
        return imports;
    }

    private static void extractFromImportEntity(ShallowEntity importEntity, ListMap<String, ShallowEntity> imports) {
        UnmodifiableList importTokens = importEntity.ownStartTokens();
        TokenPatternMatch importMatches = IMPORT_PATTERN.matchAtStartOf((List)importTokens);
        if (importMatches != null) {
            for (MatchGroupElement member : importMatches.getMatchGroup(1)) {
                imports.add((Object)member.concatTokenTexts(), (Object)importEntity);
            }
            return;
        }
        TokenPatternMatch fromImportMatches = FROM_IMPORT_PATTERN.matchAtStartOf((List)importTokens);
        if (fromImportMatches != null) {
            String packageName = ((MatchGroupElement)fromImportMatches.getMatchGroup(0).getFirst()).concatTokenTexts();
            for (String member : fromImportMatches.groupTexts(1)) {
                imports.add((Object)(packageName + "." + member), (Object)importEntity);
            }
        }
    }
}

