/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.db_0146", languages={ELanguage.SIMULINK})
public class SimulinkPositionOfConditionalAndIteratorBlocksCheck
extends CheckImplementationBase {
    private static final Set<String> CONTROL_BLOCK_TYPES = Set.of("EnablePort", "TriggerPort", "ActionPort");
    private static final Set<String> ITERATOR_BOCK_TYPES = Set.of("WhileIterator", "ForIterator", "ForEach");
    @CheckOption(name="Iterator Block Position", description="Position, where all iterator blocks shall be placed. Possible Values are: Top, Left, Right, Bottom")
    private String iteratorBlockPosition = "Top";

    public void execute() throws CheckException {
        BlockPosition expectedIteratorBlockPosition;
        try {
            expectedIteratorBlockPosition = BlockPosition.valueOf(this.iteratorBlockPosition.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException exception) {
            throw new CheckException("Illegal value for CheckOption Iterator Block Position.", (Exception)exception);
        }
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("SubSystem"), (boolean)true, (boolean)false)) {
            Set<SimulinkBlock> controlSubBlocks = SimulinkPositionOfConditionalAndIteratorBlocksCheck.getControlSubBlocks(block);
            this.checkPositionOfBlocks(block, controlSubBlocks, BlockPosition.TOP);
            Set<SimulinkBlock> iteratorSubBlocks = SimulinkPositionOfConditionalAndIteratorBlocksCheck.getIteratorSubBlocks(block);
            this.checkPositionOfBlocks(block, iteratorSubBlocks, expectedIteratorBlockPosition);
        }
    }

    private void checkPositionOfBlocks(SimulinkBlock parentSubsystem, Set<SimulinkBlock> blocksToCheck, BlockPosition expectedPosition) {
        if (blocksToCheck.isEmpty()) {
            return;
        }
        Set<SimulinkBlock> comparisonBlocks = parentSubsystem.getSubBlocks().stream().filter(block -> !blocksToCheck.contains(block)).collect(Collectors.toSet());
        double limit = SimulinkPositionOfConditionalAndIteratorBlocksCheck.getMostDistantCoordinate(comparisonBlocks, expectedPosition);
        for (SimulinkBlock block2 : blocksToCheck) {
            Rectangle rectangle;
            if (SimulinkUtils.isCommentedBlock((SimulinkBlock)block2) || !SimulinkUtils.isUserVisible((SimulinkBlock)block2) || !SimulinkPositionOfConditionalAndIteratorBlocksCheck.isInWrongPosition(rectangle = block2.obtainBlockLayoutData().getPosition(), expectedPosition, limit)) continue;
            String findingMessage = SimulinkPositionOfConditionalAndIteratorBlocksCheck.createFindingMessage(block2, expectedPosition);
            String recommendedActionMessage = SimulinkPositionOfConditionalAndIteratorBlocksCheck.createRecommendedActionMessage(block2, expectedPosition);
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(block2)).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)recommendedActionMessage)).createAndStore();
        }
    }

    private static Set<SimulinkBlock> getControlSubBlocks(SimulinkBlock block) {
        return block.getSubBlocks().stream().filter(SimulinkPositionOfConditionalAndIteratorBlocksCheck::isControlBlock).collect(Collectors.toSet());
    }

    private static boolean isControlBlock(SimulinkBlock block) {
        return CONTROL_BLOCK_TYPES.contains(block.getType());
    }

    private static Set<SimulinkBlock> getIteratorSubBlocks(SimulinkBlock block) {
        return block.getSubBlocks().stream().filter(SimulinkPositionOfConditionalAndIteratorBlocksCheck::isIteratorBlock).collect(Collectors.toSet());
    }

    private static boolean isIteratorBlock(SimulinkBlock block) {
        return ITERATOR_BOCK_TYPES.contains(block.getType());
    }

    private static boolean isInWrongPosition(Rectangle rectangle, BlockPosition expectedPosition, double limit) {
        double closestCoordinate = SimulinkPositionOfConditionalAndIteratorBlocksCheck.getClosestCoordinate(rectangle, expectedPosition);
        if (expectedPosition == BlockPosition.TOP || expectedPosition == BlockPosition.LEFT) {
            return closestCoordinate > limit;
        }
        return closestCoordinate < limit;
    }

    private static String getIteratorOrControlBlockTypeAsString(SimulinkBlock block) {
        if (SimulinkPositionOfConditionalAndIteratorBlocksCheck.isControlBlock(block)) {
            return "Control";
        }
        return "Iterator";
    }

    private static String createRecommendedActionMessage(SimulinkBlock block, BlockPosition expectedPosition) {
        return "Reposition the " + SimulinkPositionOfConditionalAndIteratorBlocksCheck.getIteratorOrControlBlockTypeAsString(block) + " block such that it is " + expectedPosition.getDescription() + " of the subsystem";
    }

    private static String createFindingMessage(SimulinkBlock block, BlockPosition expectedPosition) {
        return SimulinkPositionOfConditionalAndIteratorBlocksCheck.getIteratorOrControlBlockTypeAsString(block) + " block must be positioned " + expectedPosition.getDescription() + " of the subsystem";
    }

    private static double getMostDistantCoordinate(Set<SimulinkBlock> blocks, BlockPosition position) {
        Stream<Rectangle> rectangleStream = blocks.stream().map(block -> block.obtainBlockLayoutData().getPosition());
        switch (position.ordinal()) {
            case 1: {
                return rectangleStream.mapToDouble(RectangularShape::getMinX).min().orElse(Double.MAX_VALUE);
            }
            case 2: {
                return rectangleStream.mapToDouble(RectangularShape::getMaxX).max().orElse(Double.MIN_VALUE);
            }
            case 3: {
                return rectangleStream.mapToDouble(RectangularShape::getMaxY).max().orElse(Double.MAX_VALUE);
            }
        }
        return rectangleStream.mapToDouble(RectangularShape::getMinY).min().orElse(Double.MIN_VALUE);
    }

    private static double getClosestCoordinate(Rectangle rectangle, BlockPosition position) {
        switch (position.ordinal()) {
            case 1: {
                return rectangle.getMaxX();
            }
            case 2: {
                return rectangle.getMinX();
            }
            case 3: {
                return rectangle.getMinY();
            }
        }
        return rectangle.getMaxY();
    }

    private static enum BlockPosition {
        TOP("on the top"),
        LEFT("at the left side"),
        RIGHT("at the right side"),
        BOTTOM("on the bottom");

        private final String description;

        private BlockPosition(String description) {
            this.description = description;
        }

        private String getDescription() {
            return this.description;
        }
    }
}

