/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelUsedIdentifiersPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkVariant;

@Check(id="cqse.jmaab.jc_0792", languages={ELanguage.SIMULINK}, phases={SimulinkModelUsedIdentifiersPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkUnusedDataDictionaryDataCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Unused entry %s of type %s";

    public void execute() {
        SimulinkDataDictionary dataDictionary = this.context.getSimulinkContext().getSimulinkDataDictionaryForDictionaryFile().orElse(null);
        if (dataDictionary == null) {
            return;
        }
        List<String> models = new SimulinkCheckFileReferencesResolver(this.context).getModelsAccessingDataDictionary(this.context.getUniformPath());
        ArrayList<SimulinkModelUsedIdentifiersPhase.ModelIdentifiersValue> modelIdentifiersValues = new ArrayList<SimulinkModelUsedIdentifiersPhase.ModelIdentifiersValue>();
        for (String model : models) {
            modelIdentifiersValues.addAll((Collection)this.context.accessPhaseResult(SimulinkModelUsedIdentifiersPhase.class).apply(model));
        }
        Set<String> usedIdentifiers = SimulinkUnusedDataDictionaryDataCheck.getUsedIdentifiersFromAllReferringModels(modelIdentifiersValues);
        usedIdentifiers.addAll(SimulinkUnusedDataDictionaryDataCheck.getUsedVariablesFromDataSimulinkVariants(dataDictionary));
        for (ISimulinkDataDictionaryEntry entry : dataDictionary.getEntries()) {
            this.checkDataDictionaryEntry(entry, usedIdentifiers);
        }
    }

    private static Set<String> getUsedVariablesFromDataSimulinkVariants(SimulinkDataDictionary dataDictionary) {
        HashSet<String> usedIdentifiers = new HashSet<String>();
        for (ISimulinkDataDictionaryEntry entry : dataDictionary.getEntries()) {
            if (!(entry instanceof SimulinkVariant)) continue;
            SimulinkVariant variant = (SimulinkVariant)entry;
            usedIdentifiers.addAll(SimulinkModelUsedIdentifiersPhase.getPossibleIdentifiersFromParameterValue(variant.getCondition()));
        }
        return usedIdentifiers;
    }

    private void checkDataDictionaryEntry(ISimulinkDataDictionaryEntry entry, Set<String> usedIdentifiersFromAllReferencedModels) {
        if (!usedIdentifiersFromAllReferencedModels.contains(entry.getName())) {
            String formattedFindingMessage = String.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)entry.getName()), MarkupUtils.formatAsSourceCode((String)entry.getEntryType()));
            this.buildFinding(formattedFindingMessage, (ElementLocation)this.buildLocation().forSimulinkDataDictionaryEntry(entry)).createAndStore();
        }
    }

    private static Set<String> getUsedIdentifiersFromAllReferringModels(List<SimulinkModelUsedIdentifiersPhase.ModelIdentifiersValue> modelIdentifierDataEntries) {
        HashSet<String> usedIdentifiersInReferencedModels = new HashSet<String>();
        modelIdentifierDataEntries.forEach(modelIdentifier -> usedIdentifiersInReferencedModels.addAll(modelIdentifier.getAdditionalInformation().getUsedIdentifiers()));
        modelIdentifierDataEntries.forEach(modelIdentifier -> usedIdentifiersInReferencedModels.removeAll(modelIdentifier.getAdditionalInformation().getDefinedIdentifiers()));
        return usedIdentifiersInReferencedModels;
    }
}

