/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.audit.AuditUtils;
import com.teamscale.service.audit.TechnologyTreeMapBuilder;
import com.teamscale.service.audit.ThirdPartyDependencyExtractor;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/audit/technology")
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
public class TechnologyService
extends ApiBase {
    @GET
    @Path(value="treemap")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get treemap with the third party dependencies", description="Builds a treemap with the third party dependencies from the technology scan.", tags={"Audit"})
    public FilteredTreeMapWrapper getTechnologyTreeMap(@Parameter(description="Uniform path to retrieve files for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @BeanParam TreemapQueryOptions requestOptions, @QueryParam(value="dependency") String selectedDependency, @QueryParam(value="package-depth") int selectedPackageDepth, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException, TreeMapBuilderException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ThirdPartyDependencyExtractor dependencyExtractor = new ThirdPartyDependencyExtractor((ProjectStorageSystem)this.getProjectStorageSystem(), historyAccessOption, selectedDependency, selectedPackageDepth);
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        requestOptions.adjustTreemapRequestOptions(metricRetrievalStrategy.getMetricDirectorySchema(), false);
        TechnologyTreeMapBuilder technologyTreemapBuilder = new TechnologyTreeMapBuilder(requestOptions.includePattern, requestOptions.excludePattern, metricRetrievalStrategy, historyAccessOption, requestOptions.areaMetricIndex, requestOptions.colorMetricIndex, requestOptions.colorMetricDefaultValue, requestOptions.baseColor, dependencyExtractor, true);
        return technologyTreemapBuilder.getWrapper(uniformPath);
    }

    @GET
    @Path(value="dependencies")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="List all third party dependencies", description="Lists all third party dependencies for the project with given package depth, along with the percentage of affected files for each dependency.", tags={"Audit"})
    public List<DependencyEntry> getTechnologyDependencies(@Parameter(description="Uniform path to retrieve files for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Package depth for the given project.", required=true) @QueryParam(value="package-depth") int packageDepth, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        CommitResolvingStorageSystem storageSystem = this.getProjectStorageSystem();
        ThirdPartyDependencyExtractor dependencyExtractor = new ThirdPartyDependencyExtractor((ProjectStorageSystem)storageSystem, historyAccessOption, null, packageDepth);
        List<UniformPath> uniformPaths = AuditUtils.getSubUniformPaths((IStorageInfo)this.serviceInfo, historyAccessOption, uniformPath);
        return TechnologyService.getDependencyList(dependencyExtractor, uniformPaths);
    }

    private static List<DependencyEntry> getDependencyList(ThirdPartyDependencyExtractor dependencyExtractor, List<UniformPath> uniformPaths) throws StorageException {
        HashMap<String, Double> dependencies = new HashMap<String, Double>();
        for (UniformPath path : uniformPaths) {
            Set<String> entryDependencies = dependencyExtractor.retrieveDependencies(path.resolveToCodePath().toStringAsMigrationFrontier());
            entryDependencies.forEach(dependency -> dependencies.merge((String)dependency, 1.0, Double::sum));
        }
        if (!uniformPaths.isEmpty()) {
            double overallFiles = uniformPaths.size();
            dependencies.replaceAll((dependency, numFiles) -> 100.0 * numFiles / overallFiles);
        }
        return dependencies.entrySet().stream().map(entry -> new DependencyEntry((String)entry.getKey(), (Double)entry.getValue())).toList();
    }

    public record DependencyEntry(@JsonProperty(value="dependencyName") String dependencyName, @JsonProperty(value="affectedFilesPercentage") Double affectedFilesPercentage) implements Serializable
    {
    }
}

