/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.export;

import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.metrics.assessment.GroupAssessment;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.supercsv.io.CsvListWriter;

public class MetricAssessmentCsvConverter {
    private static final String[] HEADER = new String[]{"Group Name", "Display Name", "Metric Name", "Value Type", "Value", "Ratio Green", "Ratio Yellow", "Ratio Red", "Threshold Yellow", "Threshold Red", "Rating", "Trend", "Sub Path"};
    private List<GroupAssessment> assessmentResult;

    public MetricAssessmentCsvConverter(List<GroupAssessment> assessmentResult) {
        this.assessmentResult = assessmentResult;
    }

    public void createCsvData(CsvListWriter csvWriter) throws IOException {
        csvWriter.writeHeader(MetricAssessmentCsvConverter.createHeader());
        for (GroupAssessment groupAssessment : this.assessmentResult) {
            for (MetricAssessment metricAssessment : groupAssessment.getMetrics()) {
                List<Object> rowData = MetricAssessmentCsvConverter.createCsvRowValueList(metricAssessment, groupAssessment);
                csvWriter.write(rowData);
            }
        }
    }

    private static String[] createHeader() {
        return HEADER;
    }

    private static List<Object> createCsvRowValueList(MetricAssessment metricAssessment, GroupAssessment metricAssessmentGroup) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(metricAssessmentGroup.getName());
        rowData.add(metricAssessment.getDisplayName());
        rowData.add(metricAssessment.getMetricName());
        MetricAssessmentCsvConverter.addValueInformation(metricAssessment, rowData);
        MetricAssessmentCsvConverter.addThresholdInformation(metricAssessment, rowData);
        rowData.add(metricAssessment.getRating());
        rowData.add(metricAssessment.getTrend());
        rowData.add(metricAssessment.getSubPath());
        CCSMAssert.isTrue((rowData.size() == HEADER.length ? 1 : 0) != 0, (String)"Row length does not match the header length");
        return rowData;
    }

    private static void addValueInformation(MetricAssessment metricAssessment, List<Object> rowData) {
        rowData.add(metricAssessment.getSchemaEntry().getValueType());
        if (metricAssessment.getSchemaEntry().getValueType() == EMetricValueType.ASSESSMENT) {
            MetricAssessmentCsvConverter.addAssessmentValueInformation(metricAssessment, rowData);
        } else {
            rowData.add(metricAssessment.getValue());
            rowData.add(null);
            rowData.add(null);
            rowData.add(null);
        }
    }

    private static void addAssessmentValueInformation(MetricAssessment metricAssessment, List<Object> rowData) {
        Assessment value = (Assessment)metricAssessment.getValue();
        if (value == null || value.getSize() == 0) {
            rowData.add(0);
            rowData.add(0.0);
            rowData.add(0.0);
            rowData.add(0.0);
        } else {
            int size = value.getSize();
            rowData.add(size);
            rowData.add((double)value.getColorFrequency(ETrafficLightColor.GREEN) / (double)size);
            rowData.add((double)value.getColorFrequency(ETrafficLightColor.YELLOW) / (double)size);
            rowData.add((double)value.getColorFrequency(ETrafficLightColor.RED) / (double)size);
        }
    }

    private static void addThresholdInformation(MetricAssessment metricAssessment, List<Object> rowData) {
        if (metricAssessment.getMetricThreshold() != null) {
            rowData.add(metricAssessment.getMetricThreshold().getThresholdYellow());
            rowData.add(metricAssessment.getMetricThreshold().getThresholdRed());
        } else {
            rowData.add(null);
            rowData.add(null);
        }
    }
}

