/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.jspecify.annotations.Nullable;

public class MatchedTypesTreeMapBuilder
extends MetricTreemapBuilderBase<TreeMapNode> {
    private final Set<String> matchedTypes;

    public MatchedTypesTreeMapBuilder(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, MetricTreemapBuilderParameters parameters, Set<String> matchedTypes) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, parameters);
        this.matchedTypes = matchedTypes;
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException, TreeMapBuilderException {
        return new TreeMapNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), "", this.getColor(entry));
    }

    private @Nullable Color getColor(MetricDirectoryEntry entry) {
        return this.matchedTypes.contains(entry.getUniformPath()) ? this.builderParameters.baseColor : Color.WHITE;
    }
}

