/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.portfolio;

import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.index.portfolio.EQualityGoal;
import com.teamscale.index.portfolio.EQualityGoalAssessment;
import com.teamscale.service.portfolio.PortfolioFindingsQualityGoal;
import com.teamscale.service.portfolio.PortfolioQualityGoalAssessment;
import org.conqat.engine.persistence.store.StorageException;

public class FindingsQualityGoalAssessment
extends PortfolioQualityGoalAssessment<PortfolioFindingsQualityGoal> {
    private long nonCompliantFindingsCount;

    public FindingsQualityGoalAssessment(PortfolioFindingsQualityGoal qualityGoal) throws StorageException {
        super(qualityGoal);
    }

    @Override
    protected void runAssessment() {
        FindingDeltaCount findingDelta = ((PortfolioFindingsQualityGoal)this.qualityGoal).getFindingDeltaCount();
        int numberOfEndFindings = ((PortfolioFindingsQualityGoal)this.qualityGoal).getNumberOfEndFindings();
        int numberOfAddedFindings = findingDelta.addedFindings();
        int numberOfFindingsInChangedCode = findingDelta.findingsInChangedCode();
        this.nonCompliantFindingsCount = switch (((PortfolioFindingsQualityGoal)this.qualityGoal).getType()) {
            case EQualityGoal.QG2 -> numberOfAddedFindings;
            case EQualityGoal.QG3 -> numberOfAddedFindings + numberOfFindingsInChangedCode;
            case EQualityGoal.QG4 -> numberOfEndFindings;
            default -> 0L;
        };
    }

    @Override
    public EQualityGoalAssessment determineAssessmentResult() throws StorageException {
        return switch (((PortfolioFindingsQualityGoal)this.qualityGoal).getType()) {
            case EQualityGoal.NOT_SET -> EQualityGoalAssessment.UNKNOWN;
            case EQualityGoal.QG1 -> EQualityGoalAssessment.CRITERIA_MET;
            default -> super.determineAssessmentResult();
        };
    }

    @Override
    public boolean isGoalMet() {
        return this.nonCompliantFindingsCount == 0L;
    }
}

