/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.repository.retrievers.BranchesRetrieverFactory;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.project.RepositoryPreviewServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

@Path(value="api/branches-retriever")
public class BranchesRetrieverService
extends RepositoryPreviewServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @Operation(summary="Retrieves branches from VCSs", description="Returns set of all branches for a given VCS connector", responses={@ApiResponse(responseCode="400", description="Indicates problems with user input or project configuration.")})
    @RequiresNoPermission
    public Collection<String> previewRepositoryBranches(@RequestBody ConnectorConfiguration connectorConfiguration, @Parameter(description="The id of the project to which the connector configuration belongs") @QueryParam(value="projectId") PublicProjectId projectId) throws StorageException, RepositoryException, ServiceCallException {
        return this.previewValues(connectorConfiguration, projectId);
    }

    protected SortedSet<String> retrieveValuesFromRepository(boolean projectExists, PublicProjectId projectId, @Nullable ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws StorageException, ProjectConfigurationException, RepositoryException, ServiceCallException {
        String connectorType = connectorConfiguration.getType();
        ERepositoryConnector repositoryConnector = ERepositoryConnector.findByReadableName((String)connectorType);
        if (repositoryConnector == null) {
            throw new BadRequestException("Unsupported connector: " + connectorType);
        }
        IBranchRetriever branchRetriever = BranchesRetrieverFactory.getBranchRetriever((ConnectorConfiguration)connectorConfiguration, (ERepositoryConnector)repositoryConnector, (GlobalStorageSystem)this.getGlobalStorageSystem(), (Logger)LOGGER);
        if (branchRetriever == null) {
            throw new BadRequestException("Unsupported Version Control System: " + connectorType);
        }
        return new TreeSet<String>(branchRetriever.fetchBranches(projectExists, this.serviceInfo.getUser().getUsername(), credentials, connectorConfiguration));
    }
}

