/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.CodeScopeValidationViolation;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.migration.ProjectVersion44CodeScopeMigration;
import com.teamscale.index.migration.code_scopes.ProjectConfiguration71To98;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationMigrated;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationUnmigrated;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.project.ProjectConfigurationServiceApi;
import com.teamscale.service.project.ProjectServiceUtils;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/configuration")
public class ProjectConfigurationService
extends ApiBase
implements ProjectConfigurationServiceApi {
    @Override
    public ProjectConfiguration getProjectConfiguration(PublicProjectId projectId) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectIndex.resolveToInternalId((IProjectId)projectId), (IndexLayer)this.getIndexLayer());
        CCSMAssert.isNotNull((Object)projectConfiguration);
        return projectConfiguration.withPublicParentId(projectIndex);
    }

    @Override
    public boolean editProjectWithConfiguration(ProjectConfiguration projectConfiguration, boolean reAnalyseIfRequired, boolean skipProjectValidation) throws StorageException, BadRequestException {
        ProjectServiceUtils.validateIdentifiers(projectConfiguration);
        ProjectCreator projectCreator = new ProjectCreator(this.getIndexLayer(), this.getUser().getUsername(), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION);
        boolean reAnalysisRequired = false;
        try {
            reAnalysisRequired = this.projectReAnalysisRequired(projectConfiguration);
            if (!skipProjectValidation) {
                projectConfiguration.validate(this.getIndexLayer(), this.getUser().getUsername(), !StringUtils.isEmpty((String)projectConfiguration.getExternalStorageBackend()));
            }
            return this.getUpdateOrReAnalysisResult(projectConfiguration, projectCreator, reAnalysisRequired, reAnalyseIfRequired, !skipProjectValidation);
        }
        catch (ProjectConfigurationException e) {
            Collection codeScopeValidationViolations = e.getCodeScopeViolations();
            if (codeScopeValidationViolations != null) {
                reAnalysisRequired = true;
            }
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidationErrorResponseEntity(reAnalysisRequired, e.getMessage(), codeScopeValidationViolations, e.getConnectorIndex())).build());
        }
        catch (TriggerCompilationException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidationErrorResponseEntity(reAnalysisRequired, e.getMessage(), null, null)).build());
        }
    }

    private boolean getUpdateOrReAnalysisResult(ProjectConfiguration projectConfiguration, ProjectCreator projectCreator, boolean reAnalysisRequired, boolean reAnalyzeIfRequired, boolean validateProject) throws StorageException, ProjectConfigurationException, TriggerCompilationException {
        if (!reAnalysisRequired) {
            projectCreator.refreshProject(projectConfiguration, validateProject, true, false, validateProject);
            this.updateProjectInfosCreationTimestampToNow(projectConfiguration);
        } else if (reAnalyzeIfRequired) {
            projectCreator.refreshProject(projectConfiguration, validateProject, false, false, validateProject);
            ProjectServiceUtils.triggerReanalysis(projectConfiguration.getInternalId(), this.serviceInfo, validateProject);
        }
        return reAnalysisRequired;
    }

    private void updateProjectInfosCreationTimestampToNow(ProjectConfiguration projectConfiguration) throws StorageException {
        ProjectIndex projectIndex = this.serviceInfo.getIndexLayer().openProjectIndex();
        ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)projectConfiguration.getInternalId());
        projectInfo.setCreationTimestamp(DateTimeUtils.millisNow());
        projectIndex.setProject(projectInfo);
    }

    private boolean projectReAnalysisRequired(ProjectConfiguration newProjectConfig) throws StorageException, ProjectConfigurationException {
        ProjectConfiguration oldProjectConfig = ProjectUtils.retrieveProjectConfig((IProjectId)newProjectConfig.getInternalId(), (IndexLayer)this.getIndexLayer());
        CCSMAssert.isNotNull((Object)oldProjectConfig);
        if (this.codeScopesRequireReanalysis(newProjectConfig.getCodeScopes(), oldProjectConfig.getCodeScopes())) {
            return true;
        }
        if (!Objects.equals(oldProjectConfig.getParentProjectId(), newProjectConfig.withInternalParentId(this.getIndexLayer()).getParentProjectId())) {
            return true;
        }
        if (!Objects.equals(oldProjectConfig.getExternalStorageProjectMappingId(), newProjectConfig.getExternalStorageProjectMappingId())) {
            return true;
        }
        if (!Objects.equals(oldProjectConfig.getBranchingConfiguration(), newProjectConfig.getBranchingConfiguration())) {
            return true;
        }
        if (!Objects.equals(oldProjectConfig.getExternalStorageBackend(), newProjectConfig.getExternalStorageBackend())) {
            return true;
        }
        List newConnectors = ProjectConfiguration.retrieveConnectors((IndexLayer)this.getIndexLayer(), (String)this.getUser().getUsername(), (ProjectConfiguration)newProjectConfig, (boolean)false, (!StringUtils.isEmpty((String)newProjectConfig.getExternalStorageBackend()) ? 1 : 0) != 0);
        List<ConnectorDescriptorBase> oldConnectors = this.retrieveOldConnectors(oldProjectConfig);
        return ProjectServiceUtils.connectorsRequireReAnalysis(newConnectors, oldConnectors);
    }

    private boolean codeScopesRequireReanalysis(List<CodeScope> newCodeScopes, List<CodeScope> oldCodeScopes) {
        if (newCodeScopes.size() != oldCodeScopes.size()) {
            return true;
        }
        for (int i = 0; i < newCodeScopes.size(); ++i) {
            boolean reanalysisRequiredForScope = this.codeScopeRequiresReanalysis(newCodeScopes.get(i), oldCodeScopes.get(i));
            if (!reanalysisRequiredForScope) continue;
            return true;
        }
        return false;
    }

    private boolean codeScopeRequiresReanalysis(CodeScope newCodeScope, CodeScope oldCodeScope) {
        if (!newCodeScope.getName().equals((Object)oldCodeScope.getName())) {
            return true;
        }
        if (this.analysisProfileRequiresReanalysis(newCodeScope, oldCodeScope)) {
            return true;
        }
        if (!CollectionUtils.differenceSet((Collection)newCodeScope.getPathIncludes(), (Collection[])new Collection[]{oldCodeScope.getPathIncludes()}).isEmpty()) {
            return true;
        }
        if (!CollectionUtils.differenceSet((Collection)newCodeScope.getPathExcludes(), (Collection[])new Collection[]{oldCodeScope.getPathExcludes()}).isEmpty()) {
            return true;
        }
        if (!CollectionUtils.differenceSet((Collection)newCodeScope.getContentIncludes(), (Collection[])new Collection[]{oldCodeScope.getContentIncludes()}).isEmpty()) {
            return true;
        }
        return !CollectionUtils.differenceSet((Collection)newCodeScope.getContentExcludes(), (Collection[])new Collection[]{oldCodeScope.getContentExcludes()}).isEmpty();
    }

    private boolean analysisProfileRequiresReanalysis(CodeScope newCodeScope, CodeScope oldCodeScope) {
        AnalysisProfile oldEmbeddedAnalysisProfile = oldCodeScope.getEmbeddedProfile();
        String oldAnalysisProfileName = oldEmbeddedAnalysisProfile == null ? oldCodeScope.getProfile() : oldEmbeddedAnalysisProfile.getName();
        CCSMAssert.isNotNull((Object)oldAnalysisProfileName);
        return !oldAnalysisProfileName.equals(newCodeScope.getProfile());
    }

    private List<ConnectorDescriptorBase> retrieveOldConnectors(ProjectConfiguration oldProjectConfig) throws StorageException, ProjectConfigurationException {
        List oldConnectors;
        block2: {
            oldConnectors = Collections.emptyList();
            try {
                oldConnectors = ProjectConfiguration.retrieveConnectors((IndexLayer)this.getIndexLayer(), (String)this.getUser().getUsername(), (ProjectConfiguration)oldProjectConfig, (boolean)false, (!StringUtils.isEmpty((String)oldProjectConfig.getExternalStorageBackend()) ? 1 : 0) != 0);
            }
            catch (ProjectConfigurationException e) {
                if (e.getMessage().contains("External accounts not found: ")) break block2;
                throw e;
            }
        }
        return oldConnectors;
    }

    @Override
    public ProjectConfiguration71To98 getProjectConfiguration71To98(PublicProjectId projectId) throws StorageException {
        ProjectConfiguration projectConfiguration = this.getProjectConfiguration(projectId);
        ProjectConfiguration71To98 legacyProjectConfiguration = new ProjectConfiguration71To98(projectConfiguration.getName(), projectConfiguration.getInternalId(), projectConfiguration.getExternalStorageProjectMappingId(), (List)projectConfiguration.getPublicIds(), projectConfiguration.getAnalysisProfileName(CodeScopeAware.DEFAULT_CODE_SCOPE), projectConfiguration.getExternalStorageBackend());
        legacyProjectConfiguration.setEmbeddedProfile(projectConfiguration.getEmbeddedProfile(CodeScopeAware.DEFAULT_CODE_SCOPE));
        return legacyProjectConfiguration;
    }

    @Override
    public boolean editProjectWithConfiguration71To98(ProjectConfiguration71To98 legacyProjectConfiguration, boolean reAnalyzeIfRequired, boolean skipProjectValidation) throws StorageException, BadRequestException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationService.migrateProjectConfigToTeamscale99(legacyProjectConfiguration);
        return this.editProjectWithConfiguration(projectConfiguration, reAnalyzeIfRequired, skipProjectValidation);
    }

    @Override
    public V89ProjectConfigurationUnmigrated getProjectConfigurationTeamscale56To70(PublicProjectId projectId, boolean skipAliasResolution) throws StorageException {
        ProjectConfiguration71To98 projectConfiguration = this.getProjectConfiguration71To98(projectId);
        try {
            V89ProjectConfigurationMigrated migratedProjectConfiguration = (V89ProjectConfigurationMigrated)JsonUtils.deserializeFromJson((String)JsonUtils.serializeToJSON((Object)projectConfiguration), V89ProjectConfigurationMigrated.class);
            return new V89ProjectConfigurationUnmigrated(migratedProjectConfiguration);
        }
        catch (JsonSerializationException e) {
            throw new BadRequestException("There was a problem during conversion of the given project configuration to the legacy API format", (Throwable)e);
        }
    }

    @Override
    public boolean editProjectWithConfigurationTeamscale56To70(V89ProjectConfigurationUnmigrated legacyProjectConfiguration, boolean reAnalyseIfRequired, boolean skipProjectValidation) throws StorageException, BadRequestException {
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        Optional existingProjectInfo = projectIndex.tryResolveProject((IProjectId)new PublicProjectId(legacyProjectConfiguration.id));
        V89ProjectConfigurationMigrated newProjectConfiguration = existingProjectInfo.map(projectInfo -> new V89ProjectConfigurationMigrated(legacyProjectConfiguration, projectInfo.getInternalId())).orElseGet(() -> new V89ProjectConfigurationMigrated(legacyProjectConfiguration));
        try {
            ProjectConfiguration71To98 projectConfiguration = (ProjectConfiguration71To98)JsonUtils.deserializeFromJson((String)JsonUtils.serializeToJSON((Object)newProjectConfiguration), ProjectConfiguration71To98.class);
            projectConfiguration.setDefaultBranchingConfiguration();
            return this.editProjectWithConfiguration71To98(projectConfiguration, reAnalyseIfRequired, skipProjectValidation);
        }
        catch (JsonSerializationException e) {
            throw new BadRequestException("There was a problem during conversion of the given project configuration to the current API format", (Throwable)e);
        }
    }

    private static @NonNull ProjectConfiguration migrateProjectConfigToTeamscale99(ProjectConfiguration71To98 projectConfiguration) throws StorageException {
        try {
            String projectConfigurationJson = JsonUtils.serializeToJSON((Object)projectConfiguration);
            String migratedProjectConfigurationJson = ProjectVersion44CodeScopeMigration.migrate((String)projectConfigurationJson);
            return (ProjectConfiguration)JsonUtils.deserializeFromJson((String)migratedProjectConfigurationJson, ProjectConfiguration.class);
        }
        catch (JsonSerializationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public static class ValidationErrorResponseEntity {
        private static final String PARAMETER_RE_ANALYSIS_REQUIRED_PROPERTY = "parameterReAnalysisRequired";
        private static final String MESSAGE_PROPERTY = "message";
        private static final String CODE_SCOPE_VIOLATIONS_PROPERTY = "codeScopeViolations";
        private static final String CONNECTOR_INDEX_PROPERTY = "connectorIndex";
        @JsonProperty(value="parameterReAnalysisRequired")
        private final boolean parameterReAnalysisRequired;
        @JsonProperty(value="message")
        private final String message;
        @JsonProperty(value="codeScopeViolations")
        private final @Nullable Collection<CodeScopeValidationViolation> codeScopeViolations;
        @JsonProperty(value="connectorIndex")
        private final @Nullable Integer connectorIndex;

        @JsonCreator
        public ValidationErrorResponseEntity(@JsonProperty(value="parameterReAnalysisRequired") boolean parameterReAnalysisRequired, @JsonProperty(value="message") String message, @JsonProperty(value="codeScopeViolations") @Nullable Collection<CodeScopeValidationViolation> codeScopeViolations, @JsonProperty(value="connectorIndex") @Nullable Integer connectorIndex) {
            this.parameterReAnalysisRequired = parameterReAnalysisRequired;
            this.message = message;
            this.codeScopeViolations = codeScopeViolations;
            this.connectorIndex = connectorIndex;
        }
    }
}

