/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing.graph;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.requirements_tracing.graph.SpecItemGraphLink;
import com.teamscale.service.requirements_tracing.graph.SpecItemGraphNode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.js_export.NotExported;
import org.jetbrains.annotations.VisibleForTesting;

public class SpecItemGraph {
    private static final String NODES_PROPERTY = "nodes";
    private static final String LINKS_PROPERTY = "links";
    @JsonProperty(value="nodes")
    private SetMap<String, SpecItemGraphNode> nodes = new SetMap();
    @JsonProperty(value="links")
    private SetMap<String, SpecItemGraphLink> links = new SetMap();
    @NotExported
    @JsonIgnore
    private Map<String, String> mergedLinkRoles = new HashMap<String, String>();
    @NotExported
    @JsonIgnore
    private final Map<SpecItemGraphLink, SpecItemGraphLink> existingLinks = new HashMap<SpecItemGraphLink, SpecItemGraphLink>();

    @JsonCreator
    @VisibleForTesting
    public SpecItemGraph(@JsonProperty(value="nodes") Map<String, Set<SpecItemGraphNode>> nodes, @JsonProperty(value="links") Map<String, Set<SpecItemGraphLink>> links) {
        this.nodes = new SetMap(nodes);
        this.links = new SetMap(links);
    }

    protected SpecItemGraph(Map<String, String> mergedLinkRoles) {
        this.mergedLinkRoles = mergedLinkRoles;
    }

    public void addNode(SpecItem specItem) {
        String label = specItem.getTypeInfo().getTypeAbbreviation() + ": " + specItem.getId().getExternalId();
        String key = specItem.getTypeInfo().getType() + ": " + specItem.getTypeInfo().getTypeAbbreviation();
        SpecItemGraphNode node = new SpecItemGraphNode(specItem.getId().getInternalId(), label, key);
        this.nodes.add((Object)key, (Object)node);
    }

    public void addLink(TeamscaleIssueId specItemId, TeamscaleIssueId linkedSpecItemId, String linkRole) {
        String mergedLinkRole = this.mergedLinkRoles.getOrDefault(linkRole, linkRole);
        SpecItemGraphLink link = new SpecItemGraphLink(specItemId.getInternalId(), linkedSpecItemId.getInternalId(), mergedLinkRole);
        SpecItemGraphLink existingLink = this.existingLinks.get(link);
        if (existingLink == null) {
            this.existingLinks.put(link, link);
            this.links.add((Object)mergedLinkRole, (Object)link);
        }
    }

    @VisibleForTesting
    public SetMap<String, SpecItemGraphNode> getNodes() {
        return this.nodes;
    }

    @VisibleForTesting
    public SetMap<String, SpecItemGraphLink> getLinks() {
        return this.links;
    }
}

