/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload.base;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RevisionResolver;
import com.teamscale.index.testimpact.CommitAndRevision;
import com.teamscale.index.utils.ExternalUploadUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.input.RejectOldUploadsOption;
import com.teamscale.service.upload.base.ExternalUploadServiceQueryOptions;
import jakarta.ws.rs.BadRequestException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jspecify.annotations.Nullable;

public abstract class ExternalUploadServiceBase<S extends ExternalUploadServiceQueryOptions>
extends ApiBase {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final String REVISION_NOT_FOUND_ERROR = "Revision provided in the query parameter could not be found.";
    public static final String TIMESTAMP_TOO_OLD_ERROR = "Upload was rejected, because it refers to a timestamp too far back in time.";
    public static final String UPLOADED_FILE_PARAMETER_NAME = "file";
    public static final String SESSION_PARAMETER_DESCRIPTION = "If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.";

    protected CommitDescriptor getUploadCommit(S parameters) throws BadRequestException, StorageException {
        CommitDescriptor resolvedCommit = RevisionResolver.resolveRevisionOrCommit((CommitAndRevision)((ExternalUploadServiceQueryOptions)parameters).getCommitAndRevision(), (String)this.getUser().getUsername(), (InternalProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer());
        this.checkBranchExists(resolvedCommit.getBranchName());
        if (this.shouldRejectUpload(resolvedCommit)) {
            throw this.getUploadRejectedException(resolvedCommit);
        }
        return resolvedCommit;
    }

    private void checkBranchExists(String branchName) throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = this.openProjectIndex(ProjectRepositoryChangeIndex.class, null);
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        if (!branchName.equals(repositoryStatus.getDefaultBranchName()) && !repositoryStatus.getBranchNames().contains(branchName)) {
            LOGGER.warn("Branch " + branchName + " does not exist in Teamscale.");
        }
    }

    protected boolean shouldRejectUpload(CommitDescriptor commit) throws StorageException {
        RejectOldUploadsOption rejectOldUploadsOption = this.getRejectOldUploadsOption();
        if (rejectOldUploadsOption == null) {
            return false;
        }
        long lowestAllowedTimestamp = rejectOldUploadsOption.getMaxUploadDays().map(Duration::ofDays).map(duration -> DateTimeUtils.now().minus((TemporalAmount)duration)).orElse(Instant.EPOCH).toEpochMilli();
        return commit.getTimestamp() < lowestAllowedTimestamp;
    }

    protected BadRequestException getUploadRejectedException(CommitDescriptor rejectedCommit) throws StorageException {
        return new BadRequestException("Rejecting upload, because it refers to a timestamp too far back in time (Max allowed days: " + Objects.requireNonNull(this.getRejectOldUploadsOption()).getMaxUploadDays().map(Object::toString).orElse("n/a") + "). Given commit timestamp: " + rejectedCommit.getTimestamp() + " [" + DateTimeUtils.getUiFormattedDateString((long)rejectedCommit.getTimestamp()) + "]). The allowed value for the maximum upload age can be changed in the project options in the section 'External Uploads'.");
    }

    private @Nullable RejectOldUploadsOption getRejectOldUploadsOption() throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        ProjectOptionRegistry projectOptionRegistry = ProjectOptionRegistry.getInstance();
        return (RejectOldUploadsOption)projectOptionRegistry.getOption("<p>", "upload.max-age", null, RejectOldUploadsOption.class, (OptionIndexBase)projectOptionIndex);
    }

    protected static List<CommitDescriptor> collectCommitsNewerThanCommit(CommitLayeringBranchingLayer branchingLayer, CommitDescriptor commit) throws StorageException {
        return CollectionUtils.filterAndMap((Collection)branchingLayer.getAllTimestampsForBranch(commit.getBranchName()), timestamp -> timestamp > commit.getTimestamp(), timestamp -> new CommitDescriptor(commit.getBranchName(), timestamp.longValue()));
    }

    protected static <T> void updateRollbackedEntriesForReplay(CommitDescriptor uploadCommit, List<CommitDescriptor> rollbackedCommits, List<T> rollbackedValues) {
        if (ExternalUploadServiceBase.firstCommitKeyIsUploadCommit(uploadCommit, rollbackedCommits)) {
            rollbackedCommits.remove(0);
            rollbackedValues.remove(0);
        }
    }

    protected static boolean firstCommitKeyIsUploadCommit(CommitDescriptor uploadCommit, List<CommitDescriptor> commits) {
        return !commits.isEmpty() && commits.get(0).equals((Object)uploadCommit);
    }

    protected CommitDescriptor getCorrectedCommit(CommitDescriptor proposedCommit, boolean useCodeCommitOffset) throws StorageException {
        return ExternalUploadUtils.getAdjustedCommit((CommitDescriptor)proposedCommit, (CommitLayeringBranchingLayer)this.openExternalResultBranchingLayer(), (boolean)useCodeCommitOffset);
    }

    protected abstract IStore openExternalResultRawStore() throws StorageException;

    protected CommitLayeringBranchingLayer openExternalResultBranchingLayer() throws StorageException {
        return new CommitLayeringBranchingLayer(this.openExternalResultRawStore(), (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
    }
}

