/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.BearerAuthenticationHelper;
import com.teamscale.core.authenticate.IUserAuthenticator;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.service.authenticate.AuthenticationService;
import com.teamscale.service.autocomplete.EntityFilterHelper;
import com.teamscale.service.autocomplete.PrefixPriorityComparator;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.permissions.PermissionFilterUtils;
import com.teamscale.service.user.IUserServiceApi;
import com.teamscale.service.user.UserBatchOperation;
import com.teamscale.service.user.UserWithActivity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/users")
public class UserService
extends ApiBase
implements IUserServiceApi {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public List<UserWithActivity> getAllUsers() throws StorageException {
        List<User> users = PermissionFilterUtils.getVisibleUsers(this.getPermissions(), this.getIndex());
        UserLastActivityIndex userLastActivityIndex = this.openGlobalIndex(UserLastActivityIndex.class);
        @Nullable List lastActivities = userLastActivityIndex.getLastActivityTimestampForUsers(users.stream().map(User::getUsername).toList());
        ArrayList<UserWithActivity> usersWithActivities = new ArrayList<UserWithActivity>();
        CollectionUtils.forEach(users, (Iterable)lastActivities, (user, lastActivity) -> usersWithActivities.add((UserWithActivity)UserUtils.sanitizeUser((User)new UserWithActivity((User)user, Objects.requireNonNullElse(lastActivity, 0L)))));
        return usersWithActivities;
    }

    @Override
    public UserWithActivity getUser(String userName) throws StorageException {
        User user = this.getIndex().getUser(userName);
        if (user == null) {
            throw new NotFoundException("User with username " + userName + " was not found.");
        }
        UserLastActivityIndex userLastActivityIndex = this.openGlobalIndex(UserLastActivityIndex.class);
        Long lastActivity = (Long)userLastActivityIndex.getLastActivityTimestampForUsers(List.of(user.getUsername())).get(0);
        return (UserWithActivity)UserUtils.sanitizeUser((User)new UserWithActivity(user, Objects.requireNonNullElse(lastActivity, 0L)));
    }

    @Override
    public String deleteUsers(UserBatchOperation userBatchOperation) throws StorageException {
        if (userBatchOperation.usersToDelete.isEmpty()) {
            return "No users for deletion provided!";
        }
        return this.deleteUser(userBatchOperation.usersToDelete);
    }

    @Override
    public String deleteUser(List<String> userNames) throws StorageException {
        UserGroup adminGroup = this.openGlobalIndex(UserGroupIndex.class).getUserGroup("Administrators");
        if (CollectionUtils.subtract((Collection)Objects.requireNonNull(adminGroup).getUserNames(), userNames).isEmpty() && !BearerAuthenticationHelper.isEnabled()) {
            throw new BadRequestException("Can't delete all users of group Administrators.");
        }
        this.getPermissions().checkBasicPermissionForAll(EBasicPermissionScope.USERS, userNames, EBasicPermission.DELETE);
        UserIndex userIndex = this.getIndex();
        StringBuilder userDeletionStatus = new StringBuilder();
        for (String userName : userNames) {
            if (this.getUser().getUsername().equals(userName)) {
                userDeletionStatus.append(userName + ": May not delete own user! \n");
                continue;
            }
            User user = userIndex.getUser(userName);
            if (user == null) {
                userDeletionStatus.append(userName + ": User does not exist!\n");
                continue;
            }
            this.deleteUserAndProjectPermissions(user);
        }
        if (!userDeletionStatus.isEmpty()) {
            return "User deletion operation is ignored for following users:\n" + String.valueOf(userDeletionStatus);
        }
        return "";
    }

    private void deleteUserAndProjectPermissions(User user) throws StorageException {
        UserUtils.deleteUser((User)user, (IndexLayer)this.getIndexLayer(), (IMessageBroker)this.serviceInfo.getMessageBroker());
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        permissionIndex.deleteProjectRolesForUser(user.getUsername());
    }

    @Override
    public void putUser(String userName, UserData userData) throws StorageException {
        if (!userName.equalsIgnoreCase(userData.userName)) {
            throw new BadRequestException("Username given in path and entity must match!");
        }
        User newUser = UserService.createNewUser(userData);
        UserIndex userIndex = this.getIndex();
        userIndex.runWithUserUpdateLock(newUser.getUsername(), () -> {
            User existingUser = userIndex.getUser(userData.userName);
            if (existingUser == null) {
                this.getPermissions().checkGlobalPermission(EGlobalPermission.CREATE_USERS);
                this.checkGroupEditPermissions(userData.groupIds);
                UserService.checkNewUserIsValid(newUser);
            } else {
                this.getPermissions().checkBasicPermission(EBasicPermissionScope.USERS, userData.userName, EBasicPermission.EDIT);
                this.checkGroupEditPermissions(CollectionUtils.differenceSet(userData.groupIds, (Collection[])new Collection[]{existingUser.getGroupIds()}));
                this.checkGroupEditPermissions(CollectionUtils.differenceSet((Collection)existingUser.getGroupIds(), (Collection[])new Collection[]{userData.groupIds}));
                this.checkEmailEdit(existingUser.getEmailAddress(), userData.emailAddress, existingUser.getAuthenticator());
                newUser.setAdditionalDetailsMap(existingUser.getAdditionalDetailsMap());
                newUser.setAvatarHash(existingUser.getAvatarHash());
            }
            this.updatePassword(existingUser, newUser, userData);
            userIndex.setUser(newUser, this.serviceInfo.getMessageBroker());
            this.updateGroupMembershipsForUser(existingUser, newUser);
            if (existingUser == null) {
                this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.USERS, newUser.getUsername());
            }
        });
    }

    @Override
    public Collection<String> autocompleteUserName(String searchQuery, boolean regex, int maxResults) throws StorageException {
        if (StringUtils.isEmpty((String)searchQuery)) {
            return Collections.emptyList();
        }
        List<User> visibleUsers = this.getVisibleUsers();
        PrefixPriorityComparator<User> userComparator = new PrefixPriorityComparator<User>(searchQuery, regex, User::getFullName);
        return new EntityFilterHelper<User>(User::toWebUIString).filter(visibleUsers, searchQuery, regex, maxResults, userComparator).map(User::toWebUIString).collect(Collectors.toList());
    }

    private List<User> getVisibleUsers() throws StorageException {
        return PermissionFilterUtils.getVisibleUsers(this.getPermissions(), this.openGlobalIndex(UserIndex.class));
    }

    private UserIndex getIndex() throws StorageException {
        return this.openGlobalIndex(UserIndex.class);
    }

    private static void checkNewUserIsValid(User newUser) throws BadRequestException {
        if (UserIndex.USERNAME_FORBIDDEN_CHARACTERS_REGEX.matcher(newUser.getUsername()).matches()) {
            throw new BadRequestException("Username contains invalid characters!");
        }
        if (UserIndex.RESERVED_USERNAMES.contains(newUser.getUsername())) {
            throw new BadRequestException("Username is reserved!");
        }
        if (newUser.getAuthenticator() == null) {
            throw new BadRequestException("Field authenticator may not be null!");
        }
    }

    private static User createNewUser(UserData userData) {
        User newUser = new User(userData.userName.toLowerCase(), userData.firstName, userData.lastName, userData.emailAddress, userData.authenticator);
        newUser.setAliases(userData.aliases);
        newUser.setGroupIds(userData.groupIds);
        return newUser;
    }

    private void checkGroupEditPermissions(Set<String> groupIds) {
        this.getPermissions().checkBasicPermissionForAll(EBasicPermissionScope.GROUPS, groupIds, EBasicPermission.EDIT);
    }

    private void checkEmailEdit(String oldEmailAddress, String newEmailAddress, String authenticator) {
        boolean emailChanged;
        if (this.getPermissions().hasGlobalPermission(EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES)) {
            return;
        }
        String authenticatorName = AuthenticationManager.getAuthenticatorName((String)authenticator);
        boolean bl = emailChanged = !newEmailAddress.equals(oldEmailAddress);
        if (emailChanged && AuthenticationToolUtils.isExternalAuthenticatorIdentifier((String)authenticatorName)) {
            throw new BadRequestException("Cannot change email address of user imported from external system.");
        }
    }

    private static void setAuthenticatorToUser(User user, IUserAuthenticator authenticator, byte[] newPassword) {
        user.setAuthenticator(authenticator.generateNewAuthenticator(newPassword));
    }

    private void updateGroupMembershipsForUser(User existingUser, User newUser) throws StorageException {
        UserGroupIndex userGroupIndex = this.openGlobalIndex(UserGroupIndex.class);
        HashSet<String> groupsToAdd = new HashSet<String>(newUser.getGroupIds());
        HashSet<String> groupsToRemove = new HashSet<String>();
        if (existingUser != null) {
            groupsToRemove = new HashSet(existingUser.getGroupIds());
            groupsToRemove.removeAll(groupsToAdd);
            groupsToAdd.removeAll(existingUser.getGroupIds());
        }
        if (this.getUser().getUsername().equals(newUser.getUsername()) && groupsToRemove.contains("Administrators")) {
            throw new InternalServerErrorException("Users aren't allowed to remove themselves from the group Administrators.");
        }
        this.applyGroupMembershipUpdateForUser(newUser, userGroupIndex, groupsToAdd, groupsToRemove);
    }

    private void applyGroupMembershipUpdateForUser(User user, UserGroupIndex userGroupIndex, Set<String> groupsToAdd, Set<String> groupsToRemove) throws StorageException {
        UserGroup group;
        for (String groupId : groupsToAdd) {
            group = UserService.extractGroup(groupId, userGroupIndex, user);
            if (group == null) continue;
            group.addUser(user);
            userGroupIndex.setGroup(group);
        }
        for (String groupId : groupsToRemove) {
            group = UserService.extractGroup(groupId, userGroupIndex, user);
            if (group == null) continue;
            group.removeUser(user);
            userGroupIndex.setGroup(group);
        }
        if (!groupsToAdd.isEmpty() || !groupsToRemove.isEmpty()) {
            UserGroupUtils.invalidateCaches((IMessageBroker)this.serviceInfo.getMessageBroker());
        }
    }

    private static UserGroup extractGroup(String groupId, UserGroupIndex userGroupIndex, User user) throws StorageException {
        UserGroup group = userGroupIndex.getUserGroup(groupId);
        if (group == null) {
            LOGGER.error("Ignored non-existent group " + groupId + " during updating group memberships for user " + String.valueOf(user));
        }
        return group;
    }

    private void updatePassword(User existingUser, User newUser, UserData userData) throws BadRequestException, StorageException {
        String authenticatorName = userData.authenticator;
        if (StringUtils.isEmpty((String)authenticatorName)) {
            if (existingUser != null) {
                newUser.setAuthenticator(existingUser.getAuthenticator());
            }
            return;
        }
        IUserAuthenticator authenticator = UserService.getUserAuthenticator(authenticatorName);
        if (existingUser == null) {
            UserService.updateAuthenticator(newUser, userData.newPassword, null, authenticatorName, null, authenticator);
            return;
        }
        IUserAuthenticator existingAuthenticator = UserService.getUserAuthenticator(existingUser.getAuthenticator());
        if (!existingAuthenticator.allowsSwitching() || !authenticator.allowsSwitching()) {
            newUser.setAuthenticator(existingUser.getAuthenticator());
            return;
        }
        this.getPermissions().checkAccessAdministrativeServices();
        String oldAuthenticatorName = AuthenticationManager.getAuthenticatorName((String)existingUser.getAuthenticator());
        if (UserService.updateAuthenticator(newUser, userData.newPassword, existingUser, authenticatorName, oldAuthenticatorName, authenticator)) {
            UserUtils.invalidateUserSession((String)newUser.getUsername(), (SessionIndex)this.openGlobalIndex(SessionIndex.class), (IMessageBroker)this.serviceInfo.getMessageBroker());
        }
    }

    private static boolean updateAuthenticator(User user, char[] newPassword, User existingUser, String newAuthenticatorString, String oldAuthenticatorString, IUserAuthenticator authenticator) {
        if (!AuthenticationService.isEmptyPassword(newPassword) && authenticator.allowsPasswordChanges() && authenticator.allowsSwitching()) {
            UserUtils.wipeAfterUse((char[])newPassword, passwordBytes -> {
                UserService.setAuthenticatorToUser(user, authenticator, passwordBytes);
                return null;
            });
            return true;
        }
        if (!newAuthenticatorString.equals(oldAuthenticatorString) && authenticator.allowsSwitching()) {
            user.setAuthenticator(newAuthenticatorString);
            return true;
        }
        if (existingUser != null) {
            user.setAuthenticator(existingUser.getAuthenticator());
        }
        return false;
    }

    private static IUserAuthenticator getUserAuthenticator(String authenticatorName) throws BadRequestException {
        AuthenticationManager authManager = AuthenticationManager.getInstance();
        IUserAuthenticator authenticator = authManager.getAuthenticator(authenticatorName);
        if (authenticator == null && authenticatorName.contains(":")) {
            authenticator = authManager.getAuthenticator(AuthenticationManager.getAuthenticatorName((String)authenticatorName));
        }
        if (authenticator == null) {
            throw new BadRequestException("Unknown or unsupported authenticator: " + authenticatorName);
        }
        return authenticator;
    }

    public static class UserData {
        private static final String USERNAME_PROPERTY = "username";
        private static final String FIRST_NAME_PROPERTY = "firstName";
        private static final String LAST_NAME_PROPERTY = "lastName";
        private static final String EMAIL_ADDRESS_PROPERTY = "emailAddress";
        private static final String ALIASES_PROPERTY = "aliases";
        private static final String AUTHENTICATOR_PROPERTY = "authenticator";
        private static final String GROUP_IDS_PROPERTY = "groupIds";
        private static final String NEW_PASSWORD_PROPERTY = "newPassword";
        @JsonProperty(value="username")
        public final String userName;
        @JsonProperty(value="firstName")
        public final String firstName;
        @JsonProperty(value="lastName")
        public final String lastName;
        @JsonProperty(value="emailAddress")
        private final String emailAddress;
        @JsonProperty(value="aliases")
        private final List<String> aliases;
        @JsonProperty(value="authenticator")
        private final @Nullable String authenticator;
        @JsonProperty(value="groupIds")
        private final Set<String> groupIds;
        @JsonProperty(value="newPassword")
        @Schema(type="string")
        private final char @Nullable [] newPassword;

        @JsonCreator
        public UserData(@JsonProperty(value="username") String userName, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="emailAddress") String emailAddress, @JsonProperty(value="aliases") List<String> aliases, @JsonProperty(value="authenticator") String authenticator, @JsonProperty(value="groupIds") Set<String> groupIds, @JsonProperty(value="newPassword") @Schema(type="string") char[] newPassword) {
            this.userName = userName;
            this.firstName = firstName;
            this.lastName = lastName;
            this.emailAddress = emailAddress;
            this.aliases = aliases;
            this.authenticator = authenticator;
            this.groupIds = groupIds;
            this.newPassword = newPassword;
        }
    }
}

