/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.loading;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.sonar.classloader.ClassloaderBuilder;
import org.sonar.classloader.Mask;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginClassLoaderDef;
import org.sonarsource.sonarlint.core.plugin.commons.loading.Slf4jBridgeClassLoader;

@SonarLintSide
public class PluginClassloaderFactory {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String API_CLASSLOADER_KEY = "_api_";
    private static final String SLF4J_CLASSLOADER_KEY = "_slf4j_";

    public Map<PluginClassLoaderDef, ClassLoader> create(ClassLoader baseClassLoader, Collection<PluginClassLoaderDef> defs) {
        ClassloaderBuilder builder = new ClassloaderBuilder();
        builder.newClassloader(API_CLASSLOADER_KEY, baseClassLoader);
        builder.setMask(API_CLASSLOADER_KEY, PluginClassloaderFactory.apiMask());
        builder.newClassloader(SLF4J_CLASSLOADER_KEY, new Slf4jBridgeClassLoader(baseClassLoader));
        builder.setExportMask(SLF4J_CLASSLOADER_KEY, PluginClassloaderFactory.slf4jMask());
        for (PluginClassLoaderDef def : defs) {
            builder.newClassloader(def.getBasePluginKey());
            builder.setParent(def.getBasePluginKey(), API_CLASSLOADER_KEY, new Mask());
            builder.addSibling(def.getBasePluginKey(), SLF4J_CLASSLOADER_KEY, new Mask());
            builder.setLoadingOrder(def.getBasePluginKey(), ClassloaderBuilder.LoadingOrder.PARENT_FIRST);
            for (File jar : def.getFiles()) {
                builder.addURL(def.getBasePluginKey(), PluginClassloaderFactory.fileToUrl(jar));
            }
            PluginClassloaderFactory.exportResources(def, builder, defs);
        }
        return PluginClassloaderFactory.build(defs, builder);
    }

    private static void exportResources(PluginClassLoaderDef def, ClassloaderBuilder builder, Collection<PluginClassLoaderDef> allPlugins) {
        builder.setExportMask(def.getBasePluginKey(), def.getExportMask());
        for (PluginClassLoaderDef other : allPlugins) {
            if (other.getBasePluginKey().equals(def.getBasePluginKey())) continue;
            builder.addSibling(def.getBasePluginKey(), other.getBasePluginKey(), new Mask());
        }
    }

    private static Map<PluginClassLoaderDef, ClassLoader> build(Collection<PluginClassLoaderDef> defs, ClassloaderBuilder builder) {
        IdentityHashMap<PluginClassLoaderDef, ClassLoader> result = new IdentityHashMap<PluginClassLoaderDef, ClassLoader>(defs.size());
        Map<String, ClassLoader> classloadersByBasePluginKey = builder.build();
        for (PluginClassLoaderDef def : defs) {
            ClassLoader classloader = classloadersByBasePluginKey.get(def.getBasePluginKey());
            if (classloader == null) {
                LOG.error("Fail to create classloader for plugin '{}'", (Object)def.getBasePluginKey());
                continue;
            }
            result.put(def, classloader);
        }
        return result;
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Mask apiMask() {
        return new Mask().addInclusion("org/sonar/api/").addInclusion("org/sonarsource/api/sonarlint/").addInclusion("org/sonar/check/").addInclusion("net/sourceforge/pmd/").addInclusion("com/sonarsource/plugins/license/api/").addInclusion("org/sonarsource/sonarlint/plugin/api/").addExclusion("org/sonar/api/internal/");
    }

    private static Mask slf4jMask() {
        return new Mask().addInclusion("org/slf4j/");
    }
}

