/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.system.ServerInfo;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.ServerVersionAndStatusChecker;
import org.sonarsource.sonarlint.core.serverconnection.StoredServerInfo;

public class ServerInfoSynchronizer {
    private final ConnectionStorage storage;

    public ServerInfoSynchronizer(ConnectionStorage storage) {
        this.storage = storage;
    }

    public StoredServerInfo readOrSynchronizeServerInfo(ServerApi serverApi) {
        return this.storage.serverInfo().read().orElseGet(() -> {
            this.synchronize(serverApi);
            return this.storage.serverInfo().read().get();
        });
    }

    public void synchronize(ServerApi serverApi) {
        ServerInfo serverStatus = serverApi.system().getStatusSync();
        ServerVersionAndStatusChecker.checkServerUpAndSupported(serverStatus);
        this.storage.serverInfo().store(serverStatus);
    }
}

