/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.HotspotStatus;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.ClientTrackedFindingDto;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.LocalOnlySecurityHotspotDto;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.MatchWithServerSecurityHotspotsParams;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.MatchWithServerSecurityHotspotsResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.SecurityHotspotMatchingService;
import org.sonarsource.sonarlint.core.clientapi.backend.tracking.ServerMatchedSecurityHotspotDto;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.NewCodeDefinition;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;
import org.sonarsource.sonarlint.core.issuetracking.Tracker;
import org.sonarsource.sonarlint.core.issuetracking.Tracking;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.vcs.ActiveSonarProjectBranchRepository;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.sync.SynchronizationServiceImpl;
import org.sonarsource.sonarlint.core.tracking.ClientTrackedFindingTrackable;
import org.sonarsource.sonarlint.core.tracking.LocalOnlySecurityHotspot;
import org.sonarsource.sonarlint.core.tracking.ServerHotspotTrackable;
import org.sonarsource.sonarlint.core.utils.FutureUtils;

@Named
@Singleton
public class SecurityHotspotMatchingServiceImpl
implements SecurityHotspotMatchingService {
    private static final int FETCH_ALL_SECURITY_HOTSPOTS_THRESHOLD = 10;
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ConfigurationRepository configurationRepository;
    private final StorageService storageService;
    private final ActiveSonarProjectBranchRepository activeSonarProjectBranchRepository;
    private final SynchronizationServiceImpl synchronizationService;
    private final ExecutorService executorService;

    public SecurityHotspotMatchingServiceImpl(ConfigurationRepository configurationRepository, StorageService storageService, ActiveSonarProjectBranchRepository activeSonarProjectBranchRepository, SynchronizationServiceImpl synchronizationService) {
        this.configurationRepository = configurationRepository;
        this.storageService = storageService;
        this.activeSonarProjectBranchRepository = activeSonarProjectBranchRepository;
        this.synchronizationService = synchronizationService;
        this.executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "sonarlint-server-tracking-hotspot-updater"));
    }

    @Override
    public CompletableFuture<MatchWithServerSecurityHotspotsResponse> matchWithServerSecurityHotspots(MatchWithServerSecurityHotspotsParams params) {
        return CompletableFutures.computeAsync(cancelChecker -> {
            String configurationScopeId = params.getConfigurationScopeId();
            Optional<Binding> effectiveBindingOpt = this.configurationRepository.getEffectiveBinding(configurationScopeId);
            Optional<String> activeBranchOpt = this.activeSonarProjectBranchRepository.getActiveSonarProjectBranch(configurationScopeId);
            if (effectiveBindingOpt.isEmpty() || activeBranchOpt.isEmpty()) {
                return new MatchWithServerSecurityHotspotsResponse(params.getClientTrackedHotspotsByServerRelativePath().entrySet().stream().map(e -> Map.entry((String)e.getKey(), ((List)e.getValue()).stream().map(issue -> Either.forRight(new LocalOnlySecurityHotspotDto(UUID.randomUUID()))).collect(Collectors.toList()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            Binding binding = effectiveBindingOpt.get();
            String activeBranch = activeBranchOpt.get();
            if (params.shouldFetchHotspotsFromServer()) {
                this.refreshServerSecurityHotspots((CancelChecker)cancelChecker, binding, activeBranch, params);
            }
            Optional<NewCodeDefinition> newCodeDefinition = this.storageService.binding(binding).newCodeDefinition().read();
            Map<String, List<ClientTrackedFindingDto>> clientTrackedIssuesByServerRelativePath = params.getClientTrackedHotspotsByServerRelativePath();
            return new MatchWithServerSecurityHotspotsResponse(clientTrackedIssuesByServerRelativePath.entrySet().stream().map(e -> {
                String serverRelativePath = (String)e.getKey();
                Collection<ServerHotspot> serverHotspots = this.storageService.binding(binding).findings().loadHotspots(activeBranch, serverRelativePath);
                Collection<ClientTrackedFindingTrackable> clientHotspotTrackables = SecurityHotspotMatchingServiceImpl.toTrackables((List)e.getValue());
                List matches = SecurityHotspotMatchingServiceImpl.matchSecurityHotspots(serverHotspots, clientHotspotTrackables).stream().map(result -> {
                    if (result.isLeft()) {
                        ServerHotspot serverSecurityHotspot = (ServerHotspot)result.getLeft();
                        Instant creationDate = serverSecurityHotspot.getCreationDate();
                        Boolean isOnNewCode = newCodeDefinition.map(definition -> definition.isOnNewCode(creationDate.toEpochMilli())).orElse(true);
                        return Either.forLeft(new ServerMatchedSecurityHotspotDto(UUID.randomUUID(), serverSecurityHotspot.getKey(), creationDate.toEpochMilli(), HotspotStatus.valueOf(serverSecurityHotspot.getStatus().name()), isOnNewCode));
                    }
                    return Either.forRight(new LocalOnlySecurityHotspotDto(((LocalOnlySecurityHotspot)result.getRight()).getId()));
                }).collect(Collectors.toList());
                return Map.entry(serverRelativePath, matches);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        });
    }

    private void refreshServerSecurityHotspots(CancelChecker cancelChecker, Binding binding, String activeBranch, MatchWithServerSecurityHotspotsParams params) {
        Set<String> serverFileRelativePaths = params.getClientTrackedHotspotsByServerRelativePath().keySet();
        boolean downloadAllSecurityHotspotsAtOnce = serverFileRelativePaths.size() > 10;
        LinkedList fetchTasks = new LinkedList();
        if (downloadAllSecurityHotspotsAtOnce) {
            fetchTasks.add(this.executorService.submit(() -> this.synchronizationService.fetchProjectHotspots(binding, activeBranch)));
        } else {
            fetchTasks.addAll(serverFileRelativePaths.stream().map(serverFileRelativePath -> this.executorService.submit(() -> this.synchronizationService.fetchFileHotspots(binding, activeBranch, (String)serverFileRelativePath))).collect(Collectors.toList()));
        }
        Future<?> waitForTasksTask = this.executorService.submit(() -> FutureUtils.waitForTasks(cancelChecker, fetchTasks, "Wait for server hotspots", Duration.ofSeconds(20L)));
        FutureUtils.waitForTask(cancelChecker, waitForTasksTask, "Wait for server hotspots (global timeout)", Duration.ofSeconds(60L));
    }

    private static List<Either<ServerHotspot, LocalOnlySecurityHotspot>> matchSecurityHotspots(Collection<ServerHotspot> serverHotspots, Collection<ClientTrackedFindingTrackable> clientTrackedHotspotTrackables) {
        Tracker tracker = new Tracker();
        Tracking trackingResult = tracker.track(() -> new ArrayList(clientTrackedHotspotTrackables), () -> SecurityHotspotMatchingServiceImpl.toServerHotspotTrackables(serverHotspots));
        return clientTrackedHotspotTrackables.stream().map(clientTrackedFindingTrackable -> {
            Object match = trackingResult.getMatch(clientTrackedFindingTrackable);
            if (match != null) {
                return Either.forLeft(((ServerHotspotTrackable)match).getServerHotspot());
            }
            return Either.forRight(new LocalOnlySecurityHotspot(UUID.randomUUID()));
        }).collect(Collectors.toList());
    }

    private static Collection<ClientTrackedFindingTrackable> toTrackables(List<ClientTrackedFindingDto> clientTrackedFindings) {
        return clientTrackedFindings.stream().map(ClientTrackedFindingTrackable::new).collect(Collectors.toList());
    }

    private static Collection<Trackable> toServerHotspotTrackables(Collection<ServerHotspot> serverHotspots) {
        return serverHotspots.stream().map(ServerHotspotTrackable::new).collect(Collectors.toList());
    }

    @PreDestroy
    public void shutdown() {
        if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
            LOG.warn("Unable to stop hotspot updater executor service in a timely manner");
        }
    }
}

