/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ConstantDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S115")
public class ConstantNameCheck
extends PHPVisitorCheck {
    public static final String KEY = "S115";
    private static final String MESSAGE = "Rename this constant \"%s\" to match the regular expression %s.";
    public static final String DEFAULT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree functionCall) {
        if ("define".equals(CheckUtils.getLowerCaseFunctionName(functionCall))) {
            CheckUtils.argumentValue(functionCall, "constant_name", 0).filter(constantName -> constantName.is(Tree.Kind.REGULAR_STRING_LITERAL)).map(LiteralTree.class::cast).ifPresent(constantName -> this.checkConstantName((Tree)constantName, CheckUtils.trimQuotes(constantName)));
        }
        super.visitFunctionCall(functionCall);
    }

    @Override
    public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
        if (tree.is(Tree.Kind.CLASS_CONSTANT_PROPERTY_DECLARATION)) {
            this.checkDeclarations(tree.declarations());
        }
        super.visitClassPropertyDeclaration(tree);
    }

    @Override
    public void visitConstDeclaration(ConstantDeclarationTree tree) {
        this.checkDeclarations(tree.declarations());
        super.visitConstDeclaration(tree);
    }

    private void checkDeclarations(SeparatedList<VariableDeclarationTree> declarations) {
        for (VariableDeclarationTree declaration : declarations) {
            String constantName = declaration.identifier().text();
            this.checkConstantName(declaration.identifier(), constantName);
        }
    }

    private void checkConstantName(Tree tree, String constName) {
        String constNameWithoutNamespace = constName;
        if (constName.contains("\\")) {
            constNameWithoutNamespace = constName.substring(constName.lastIndexOf("\\") + 1);
        }
        if (!this.pattern.matcher(constNameWithoutNamespace).matches()) {
            this.context().newIssue(this, tree, String.format(MESSAGE, constName, this.format));
        }
    }
}

