/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class UnderlinedRange
implements Comparable<UnderlinedRange> {
    public final int line;
    public final int column;
    public final int endLine;
    public final int endColumn;

    public UnderlinedRange(int line, int column, int endLine, int endColumn) {
        this.line = line;
        this.column = column;
        this.endLine = endLine;
        this.endColumn = endColumn;
        if (endLine < line || endLine == line && endColumn < column) {
            throw new IndexOutOfBoundsException(this.toString());
        }
        if (line < 1 || column < 1 || endLine != line && endColumn < 1) {
            throw new IndexOutOfBoundsException(this.toString());
        }
    }

    public boolean equals(Object other) {
        return other instanceof UnderlinedRange && this.compareTo((UnderlinedRange)other) == 0;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.line + this.column) + this.endLine) + this.endColumn;
    }

    @Override
    public int compareTo(UnderlinedRange other) {
        int diff = Integer.compare(this.line, other.line);
        if (diff != 0) {
            return diff;
        }
        diff = Integer.compare(this.column, other.column);
        if (diff != 0) {
            return diff;
        }
        diff = Integer.compare(this.endLine, other.endLine);
        if (diff != 0) {
            return diff;
        }
        return Integer.compare(this.endColumn, other.endColumn);
    }

    public String toString() {
        return "(" + this.line + ":" + this.column + "," + this.endLine + ":" + this.endColumn + ")";
    }

    public void underline(int indent, StringBuilder textLine) {
        for (int i = textLine.length(); i < indent + this.column - 1; ++i) {
            textLine.append(' ');
        }
        if (textLine.length() > 0 && textLine.charAt(textLine.length() - 1) == '^') {
            textLine.append(' ');
        }
        if (textLine.length() >= indent + this.column || this.endLine != this.line) {
            ArrayList<CallSite> params = new ArrayList<CallSite>();
            if (textLine.length() >= indent + this.column) {
                params.add((CallSite)((Object)("sc=" + this.column)));
            }
            if (this.endLine > this.line) {
                params.add((CallSite)((Object)("el=+" + (this.endLine - this.line))));
            }
            params.add((CallSite)((Object)("ec=" + this.endColumn)));
            textLine.append("^[");
            textLine.append(params.stream().collect(Collectors.joining(";")));
            textLine.append("]");
        } else {
            while (textLine.length() < indent + this.endColumn) {
                textLine.append('^');
            }
        }
    }
}

