/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueFieldLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=TextRegionLocation.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TeamscaleIssueFieldLocation.class, name="TeamscaleIssueFieldLocation")})
@IndexValueClass(containedInBackup=true)
@Schema(allOf={ElementLocation.class})
public class TextRegionLocation
extends ElementLocation {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_TEXT_REGION_OFFSET = -1;
    private static final String RAW_START_OFFSET_PROPERTY = "rawStartOffset";
    private static final String RAW_END_OFFSET_PROPERTY = "rawEndOffset";
    private static final String RAW_START_LINE_PROPERTY = "rawStartLine";
    private static final String RAW_END_LINE_PROPERTY = "rawEndLine";
    @JsonProperty(value="rawStartOffset")
    private final int rawStartOffset;
    @JsonProperty(value="rawEndOffset")
    private final int rawEndOffset;
    @JsonProperty(value="rawStartLine")
    private final int rawStartLine;
    @JsonProperty(value="rawEndLine")
    private final int rawEndLine;

    public TextRegionLocation(TextRegionLocation location) {
        super(location.getUniformPath());
        this.rawStartOffset = location.rawStartOffset;
        this.rawEndOffset = location.rawEndOffset;
        this.rawStartLine = location.rawStartLine;
        this.rawEndLine = location.rawEndLine;
    }

    @JsonCreator
    public TextRegionLocation(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="rawStartOffset") int rawStartOffset, @JsonProperty(value="rawEndOffset") int rawEndOffset, @JsonProperty(value="rawStartLine") int rawStartLine, @JsonProperty(value="rawEndLine") int rawEndLine) {
        super(uniformPath);
        CCSMAssert.isTrue((rawStartOffset <= rawEndOffset ? 1 : 0) != 0, (String)"Start offset may not be after end offset.");
        CCSMAssert.isTrue((rawStartLine <= rawEndLine ? 1 : 0) != 0, (String)"Start line may not be after end line.");
        this.rawStartOffset = rawStartOffset;
        this.rawEndOffset = rawEndOffset;
        this.rawStartLine = rawStartLine;
        this.rawEndLine = rawEndLine;
    }

    public int getRawStartOffset() {
        return this.rawStartOffset;
    }

    public int getRawEndOffset() {
        return this.rawEndOffset;
    }

    public int getRawStartLine() {
        return this.rawStartLine;
    }

    public int getRawEndLine() {
        return this.rawEndLine;
    }

    @Override
    public String toLocationString() {
        return super.toLocationString() + ":" + this.rawStartLine + "-" + this.rawEndLine;
    }

    @Override
    public String getLocationKey() {
        return this.toLocationString() + " (offsets: " + this.rawStartOffset + "-" + this.rawEndOffset + ")";
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextRegionLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextRegionLocation)) {
            return false;
        }
        TextRegionLocation that = (TextRegionLocation)o;
        return that.canEqual(this) && this.rawStartOffset == that.rawStartOffset && this.rawEndOffset == that.rawEndOffset && this.rawStartLine == that.rawStartLine && this.rawEndLine == that.rawEndLine && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rawStartOffset, this.rawEndOffset, this.rawStartLine, this.rawEndLine);
    }
}

