/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.teamscale.commons.utils.StringPool;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public final class UniformPath
implements Comparable<UniformPath>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEGMENT_SEPARATOR = "/";
    private static final Function<String, String> INTERN = StringPool::intern;
    static final String SEGMENTS_LIST_MAY_NOT_BE_NULL = "Segments list may not be null";
    private static final UnmodifiableSet<String> RELATIVE_SEGMENTS = CollectionUtils.asUnmodifiable(Set.of(".", ".."));
    private static final UnmodifiableMap<CharSequence, CharSequence> ESCAPE_MAP = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"/", (Object)"\\/"), Pair.createPair((Object)"\\", (Object)"\\\\")});
    private static final String COMPONENT_TO_FILE_SEGMENT = "-src-";
    private final EType type;
    private final UnmodifiableList<String> segments;
    private transient int cachedHashCode;
    private transient boolean hashComputed;
    private transient String cachedToString;

    private UniformPath(EType pathType) {
        this(pathType, (UnmodifiableList<String>)CollectionUtils.emptyList());
    }

    private UniformPath(EType pathType, UnmodifiableList<String> pathSegments) {
        Objects.requireNonNull(pathType, "pathType");
        Objects.requireNonNull(pathSegments, "pathSegments");
        this.type = pathType;
        this.segments = pathSegments;
    }

    static UnmodifiableList<String> intern(List<String> segments) {
        return CollectionUtils.asUnmodifiable(segments.stream().map(INTERN).toList());
    }

    public static UniformPath ofSegments(String ... segments) {
        Preconditions.checkNotNull((Object)segments, (Object)SEGMENTS_LIST_MAY_NOT_BE_NULL);
        return UniformPath.ofSegments(Arrays.asList(segments));
    }

    public static UniformPath ofSegments(EType type, String ... segments) {
        Preconditions.checkNotNull((Object)segments, (Object)SEGMENTS_LIST_MAY_NOT_BE_NULL);
        return UniformPath.ofSegments(type, Arrays.asList(segments));
    }

    public static UniformPath ofSegments(EType type, List<String> segments) {
        UniformPath.checkSegmentsValidity(segments);
        UniformPath.checkDoesNotStartWithProjectOrRepositoryName(segments);
        if (segments.isEmpty()) {
            return new UniformPath(type);
        }
        Optional<EType> pathType = EType.parse(segments.getFirst());
        if (pathType.isPresent()) {
            if (pathType.get() != type) {
                throw new IllegalArgumentException("Uniform path of type " + String.valueOf((Object)type) + " did start with " + segments.getFirst());
            }
            return new UniformPath(pathType.get(), UniformPath.intern(segments.subList(1, segments.size())));
        }
        return new UniformPath(type, UniformPath.intern(segments));
    }

    private static @NonNull UniformPath ofSegmentsUnsafe(EType type, List<String> segments) {
        return new UniformPath(type, UniformPath.intern(segments));
    }

    public static UniformPath ofSegments(List<String> segments) {
        UniformPath.checkSegmentsValidity(segments);
        UniformPath.checkDoesNotStartWithProjectOrRepositoryName(segments);
        if (segments.isEmpty()) {
            return new UniformPath(EType.CODE);
        }
        Optional<EType> pathType = EType.parse(segments.getFirst());
        if (pathType.isPresent()) {
            return new UniformPath(pathType.get(), UniformPath.intern(segments.subList(1, segments.size())));
        }
        return new UniformPath(EType.CODE, UniformPath.intern(segments));
    }

    @JsonCreator
    public static UniformPath parse(String path) {
        return UniformPathCompatibilityUtil.convert(path);
    }

    public static UniformPath parse(EType type, String path) {
        return UniformPathCompatibilityUtil.convert(type, path);
    }

    private static void checkSegmentsValidity(List<String> segments) {
        Preconditions.checkNotNull(segments, (Object)SEGMENTS_LIST_MAY_NOT_BE_NULL);
        for (String segment : segments) {
            UniformPath.checkSegmentValidity(segment, segments, StringUtils::isEmpty, "empty segment");
            UniformPath.checkSegmentValidity(segment, segments, arg_0 -> RELATIVE_SEGMENTS.contains(arg_0), "relative segment");
            UniformPath.checkSegmentValidity(segment, segments, UniformPath::containsUnescapedSlash, "contains unescaped slash");
        }
    }

    static boolean containsUnescapedSlash(String data) {
        int indexOfLastSlash = data.indexOf(47);
        while (indexOfLastSlash != -1) {
            if (indexOfLastSlash == 0 || data.charAt(indexOfLastSlash - 1) != '\\') {
                return true;
            }
            indexOfLastSlash = data.indexOf(47, indexOfLastSlash + 1);
        }
        return false;
    }

    private static void checkDoesNotStartWithProjectOrRepositoryName(List<String> segments) throws AssertionError {
        if (segments.size() > 1 && EType.parse(segments.get(1)).isPresent()) {
            String pathWithErrorHighlighting = "[" + segments.getFirst() + "]/" + StringUtils.concat(segments.subList(1, segments.size()), (String)SEGMENT_SEPARATOR);
            throw new IllegalArgumentException("Invalid path (includes project or repository information): " + pathWithErrorHighlighting);
        }
    }

    static void checkSegmentValidity(String segment, List<String> segments, Predicate<String> errorCheck, String errorDetailMessage) {
        if (errorCheck.test(segment)) {
            List pathSegmentsWithErrorHighlighting = CollectionUtils.map(segments, pathSegment -> {
                if (errorCheck.test((String)pathSegment)) {
                    return "[" + pathSegment + "]";
                }
                return pathSegment;
            });
            throw new IllegalArgumentException(String.format("Invalid path (%s): %s", errorDetailMessage, String.join((CharSequence)SEGMENT_SEPARATOR, pathSegmentsWithErrorHighlighting)));
        }
    }

    public static UniformPath root(EType type) {
        return new UniformPath(type);
    }

    public static UniformPath codeRoot() {
        return new UniformPath(EType.CODE);
    }

    public static UniformPath testImplementationRoot() {
        return new UniformPath(EType.TEST_IMPLEMENTATION);
    }

    public static UniformPath testExecutionRoot() {
        return new UniformPath(EType.TEST_EXECUTION);
    }

    public static UniformPath executableUnitRoot() {
        return new UniformPath(EType.EXECUTION_UNIT);
    }

    public static UniformPath nonCodeRoot() {
        return new UniformPath(EType.NON_CODE);
    }

    public static UniformPath specItemQueryRoot() {
        return new UniformPath(EType.SPEC_ITEM_QUERY);
    }

    public static String escapeSegment(String segment) {
        if (".".equals(segment)) {
            return "\\.";
        }
        if ("..".equals(segment)) {
            return "\\.\\.";
        }
        return StringUtils.escapeChars((String)segment, ESCAPE_MAP);
    }

    public static String unescapeSegment(String segment) {
        if ("\\.".equals(segment)) {
            return ".";
        }
        if ("\\.\\.".equals(segment)) {
            return "..";
        }
        return StringUtils.unescapeChars((String)segment, ESCAPE_MAP);
    }

    public UniformPath getParent() {
        Preconditions.checkState((!this.segments.isEmpty() ? 1 : 0) != 0, (Object)"Cannot get the parent of the root path");
        return new UniformPath(this.type, (UnmodifiableList<String>)this.segments.subList(0, this.segments.size() - 1));
    }

    public boolean hasParent() {
        return !this.isRoot();
    }

    public String getLastSegment() {
        Preconditions.checkState((!this.segments.isEmpty() ? 1 : 0) != 0, (Object)"Cannot get the last segment of the root path");
        return (String)this.segments.getLast();
    }

    public RelativeUniformPath getSubPath(int numberOfTopLevelSegmentsToRemove) {
        Preconditions.checkArgument((numberOfTopLevelSegmentsToRemove <= this.segments.size() ? 1 : 0) != 0, (String)"Cannot remove more segments than are contained in this path: %s segments to remove, path is %s", (int)numberOfTopLevelSegmentsToRemove, (Object)this);
        return RelativeUniformPath.of((List<String>)this.segments.subList(numberOfTopLevelSegmentsToRemove, this.segments.size()));
    }

    public Optional<RelativeUniformPath> getSubPathAfter(String segment) {
        int separatorIndex = this.segments.indexOf((Object)segment);
        if (separatorIndex < 0) {
            return Optional.empty();
        }
        return Optional.of(RelativeUniformPath.of((List<String>)this.segments.subList(separatorIndex + 1, this.segments.size())));
    }

    public static boolean isValidPath(String uniformPath) {
        if (uniformPath == null) {
            return false;
        }
        List<String> segments = UniformPathCompatibilityUtil.getAbsoluteSegments(uniformPath);
        try {
            UniformPath.checkSegmentsValidity(segments);
            UniformPath.checkDoesNotStartWithProjectOrRepositoryName(segments);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public UniformPath resolveToCodePath() {
        return switch (this.type.ordinal()) {
            case 2 -> this.getSubPathAfter(COMPONENT_TO_FILE_SEGMENT).map(subPath -> UniformPath.codeRoot().resolve((RelativeUniformPath)subPath)).orElseGet(() -> new UniformPath(EType.CODE, this.segments));
            case 11 -> {
                if (this.segments.size() <= 1) {
                    yield UniformPath.codeRoot();
                }
                yield UniformPath.codeRoot().resolve(RelativeUniformPath.of((List<String>)this.segments.subList(1, this.segments.size())));
            }
            default -> this;
        };
    }

    public boolean isRoot() {
        return this.segments.isEmpty();
    }

    public boolean isCodePath() {
        return this.type == EType.CODE;
    }

    public Optional<CodeScopeName> getCodeScope() {
        if (this.type != EType.CODE_SCOPES) {
            throw new IllegalStateException("Path is not a code scope path");
        }
        if (this.segments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CodeScopeName((String)this.segments.getFirst()));
    }

    public boolean isNonCodePath() {
        return this.type == EType.NON_CODE;
    }

    public boolean isArchitecturePath() {
        return this.type == EType.ARCHITECTURE;
    }

    public boolean isCodeScopesPath() {
        return this.type == EType.CODE_SCOPES;
    }

    public boolean isIssueItemPath() {
        return this.type == EType.ISSUE_ITEM;
    }

    public boolean isIssueQueryPath() {
        return this.type == EType.ISSUE_QUERY;
    }

    public boolean isSpecItemPath() {
        return this.type == EType.SPEC_ITEM;
    }

    public boolean isSpecItemQueryPath() {
        return this.type == EType.SPEC_ITEM_QUERY;
    }

    public boolean isTestImplementationPath() {
        return this.type == EType.TEST_IMPLEMENTATION;
    }

    public boolean isTestExecutionPath() {
        return this.type == EType.TEST_EXECUTION;
    }

    public boolean isTestQueryPath() {
        return this.type == EType.TEST_QUERY;
    }

    public boolean isExecutionUnit() {
        return this.type == EType.EXECUTION_UNIT;
    }

    public boolean isVirtualCodePath() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 11 -> true;
            case 0, 1, 3, 4, 5, 6, 7, 8, 9, 10 -> false;
        };
    }

    public EType getType() {
        return this.type;
    }

    public UnmodifiableList<String> getPathSegments() {
        return this.segments;
    }

    public String getPathSegmentsString() {
        return StringUtils.concat(this.segments, (String)SEGMENT_SEPARATOR);
    }

    public UniformPath resolve(String relativePath) {
        return this.resolve(RelativeUniformPath.of(relativePath));
    }

    public UniformPath resolve(RelativeUniformPath relativePath) {
        ArrayList<String> segments = new ArrayList<String>((Collection<String>)this.segments);
        segments.addAll((Collection<String>)relativePath.getSegments());
        return UniformPath.ofSegments(this.type, RelativeUniformPath.resolveRelativeSegments(segments));
    }

    public boolean hasAncestor(UniformPath ancestorPath) {
        if (this.type != ancestorPath.type) {
            return false;
        }
        UnmodifiableList<String> containingPathSegments = ancestorPath.segments;
        if (containingPathSegments.size() > this.segments.size()) {
            return false;
        }
        return this.segments.subList(0, containingPathSegments.size()).equals(containingPathSegments);
    }

    public boolean hasDescendant(UniformPath descendantPath) {
        if (this.type != descendantPath.type) {
            return false;
        }
        UnmodifiableList<String> descendantPathSegments = descendantPath.segments;
        if (descendantPathSegments.size() < this.segments.size()) {
            return false;
        }
        return this.segments.equals(descendantPathSegments.subList(0, this.segments.size()));
    }

    @JsonValue
    public String toString() {
        this.initializeCachedToStringIfNecessary();
        return this.cachedToString;
    }

    private void initializeCachedToStringIfNecessary() {
        if (this.cachedToString != null) {
            return;
        }
        this.cachedToString = this.isCodePath() ? this.getPathSegmentsString() : (this.isRoot() ? this.type.getPrefix() : this.type.getPrefix() + SEGMENT_SEPARATOR + this.getPathSegmentsString());
    }

    public String toStringAsMigrationFrontier() {
        return this.toString();
    }

    public int hashCode() {
        if (!this.hashComputed) {
            this.cachedHashCode = Objects.hash(new Object[]{this.type, this.segments});
            this.hashComputed = true;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UniformPath)) {
            return false;
        }
        UniformPath other = (UniformPath)obj;
        return this.type == other.type && this.segments.equals(other.segments);
    }

    @Override
    public int compareTo(UniformPath other) {
        int compareToResult = this.type.getPrefix().compareTo(other.type.getPrefix());
        if (compareToResult != 0) {
            if (this.isCodePath() || other.isCodePath()) {
                return this.toString().compareTo(other.toString());
            }
            return compareToResult;
        }
        for (int i = 0; i < Math.min(this.segments.size(), other.segments.size()); ++i) {
            compareToResult = ((String)this.segments.get(i)).compareTo((String)other.segments.get(i));
            if (compareToResult == 0) continue;
            return compareToResult;
        }
        return this.segments.size() - other.segments.size();
    }

    private Object writeReplace() {
        return new Ser(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }

    private void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type.ordinal());
        out.writeInt(this.segments.size());
        for (String segment : this.segments) {
            out.writeObject(segment);
        }
    }

    private static UniformPath readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte ordinal = in.readByte();
        int segmentCount = in.readInt();
        ArrayList<String> segments = new ArrayList<String>(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            segments.add(INTERN.apply((String)in.readObject()));
        }
        return new UniformPath(EType.VALUES[ordinal], (UnmodifiableList<String>)CollectionUtils.asUnmodifiable(segments));
    }

    public UniformPath asCodeScopePath(CodeScopeName codeScopeName) {
        ArrayList<String> segments = new ArrayList<String>((Collection<String>)this.getPathSegments());
        segments.addFirst(INTERN.apply(codeScopeName.toString()));
        return new UniformPath(EType.CODE_SCOPES, (UnmodifiableList<String>)CollectionUtils.asUnmodifiable(segments));
    }

    @ExportToTypeScript
    @IndexValueClass
    public static enum EType {
        CODE("-code-"),
        NON_CODE("-non-code-"),
        ARCHITECTURE("-architectures-"),
        TEST_IMPLEMENTATION("-test-implementation-"),
        TEST_EXECUTION("-test-execution-"),
        TEST_QUERY("-test-query-"),
        ISSUE_ITEM("-issue-item-"),
        ISSUE_QUERY("-issues-"),
        SPEC_ITEM("-spec-item-"),
        SPEC_ITEM_QUERY("-spec-items-"),
        EXECUTION_UNIT("-execution-unit-"),
        CODE_SCOPES("-code-scopes-");

        private static final EType[] VALUES;
        private static final UnmodifiableMap<String, EType> PREFIX_TO_TYPE_MAPPING;
        private final String prefix;

        private EType(String prefix) {
            this.prefix = prefix;
        }

        public static Optional<EType> parse(String typeString) {
            return Optional.ofNullable((EType)((Object)PREFIX_TO_TYPE_MAPPING.get((Object)typeString)));
        }

        public static EType valueOf(int ordinal) {
            return VALUES[ordinal];
        }

        public String getPrefix() {
            return this.prefix;
        }

        static {
            VALUES = EType.values();
            PREFIX_TO_TYPE_MAPPING = CollectionUtils.asUnmodifiable(Arrays.stream(VALUES).collect(Collectors.toMap(EType::getPrefix, Function.identity())));
        }
    }

    private static final class Ser
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private UniformPath delegate;

        public Ser(UniformPath delegate) {
            this.delegate = delegate;
        }

        public Ser() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.delegate.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.delegate = UniformPath.readExternal(in);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }
}

