/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.handler;

import io.prometheus.metrics.core.metrics.CounterWithCallback;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.handler.StatisticsHandler;

public class JettyStatisticsCollector {
    private final StatisticsHandler statisticsHandler;

    public JettyStatisticsCollector(StatisticsHandler statisticsHandler) {
        this.statisticsHandler = statisticsHandler;
        this.initializeMetrics();
    }

    private void initializeMetrics() {
        ((CounterWithCallback.Builder)CounterWithCallback.builder().name("jetty_requests_total").help("Number of requests")).callback(cb -> cb.call((double)this.statisticsHandler.getRequestTotal(), new String[0])).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("jetty_requests_active")).help("Number of requests currently active")).callback(cb -> cb.call((double)this.statisticsHandler.getRequestsActive(), new String[0])).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("jetty_requests_active_max")).help("Maximum number of requests that have been active at once")).callback(cb -> cb.call((double)this.statisticsHandler.getRequestsActiveMax(), new String[0])).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("jetty_request_time_max_seconds")).help("Maximum time spent handling requests")).unit(Unit.SECONDS)).callback(cb -> cb.call((double)TimeUnit.NANOSECONDS.toSeconds(this.statisticsHandler.getRequestTimeMax()), new String[0])).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("jetty_request_time_seconds_total").help("Total time spent in all request handling")).unit(Unit.SECONDS)).callback(cb -> cb.call((double)TimeUnit.NANOSECONDS.toSeconds(this.statisticsHandler.getRequestTimeTotal()), new String[0])).register();
        ((CounterWithCallback.Builder)CounterWithCallback.builder().name("jetty_dispatched_total").help("Number of dispatches")).callback(cb -> cb.call((double)this.statisticsHandler.getHandleTotal(), new String[0])).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("jetty_dispatched_active")).help("Number of dispatches currently active")).callback(cb -> cb.call((double)this.statisticsHandler.getHandleActive(), new String[0])).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("jetty_dispatched_active_max")).help("Maximum number of active dispatches being handled")).callback(cb -> cb.call((double)this.statisticsHandler.getHandleActiveMax(), new String[0])).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("jetty_dispatched_time_max")).help("Maximum time spent in dispatch handling")).unit(Unit.SECONDS)).callback(cb -> cb.call((double)TimeUnit.NANOSECONDS.toSeconds(this.statisticsHandler.getHandleTimeMax()), new String[0])).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("jetty_dispatched_time_seconds_total").help("Total time spent in dispatch handling")).unit(Unit.SECONDS)).callback(cb -> cb.call((double)TimeUnit.NANOSECONDS.toSeconds(this.statisticsHandler.getHandleTimeTotal()), new String[0])).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("jetty_responses_total").help("Number of requests with response status")).labelNames(new String[]{"code"})).callback(cb -> {
            cb.call((double)this.statisticsHandler.getResponses1xx(), new String[]{"1xx"});
            cb.call((double)this.statisticsHandler.getResponses2xx(), new String[]{"2xx"});
            cb.call((double)this.statisticsHandler.getResponses3xx(), new String[]{"3xx"});
            cb.call((double)this.statisticsHandler.getResponses4xx(), new String[]{"4xx"});
            cb.call((double)this.statisticsHandler.getResponses5xx(), new String[]{"5xx"});
        }).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("jetty_stats_seconds")).help("Maximum time spent in dispatch handling")).unit(Unit.SECONDS)).callback(cb -> cb.call((double)this.statisticsHandler.getStatisticsDuration().toSeconds(), new String[0])).register();
        ((CounterWithCallback.Builder)((CounterWithCallback.Builder)CounterWithCallback.builder().name("jetty_responses_bytes_total").help("Total number of bytes across all responses")).unit(Unit.BYTES)).callback(cb -> cb.call((double)this.statisticsHandler.getBytesWritten(), new String[0])).register();
    }
}

