/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.jsbuild.export.ExportTypeException;
import com.teamscale.jsbuild.export.GenericFieldExporterBase;
import com.teamscale.jsbuild.export.TypescriptType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Optional;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class GenericCollectionFieldExporter
extends GenericFieldExporterBase {
    @Override
    public Optional<TypescriptType> resolveJavaScriptType(Class<?> clazz, AnnotatedType annotatedType, Member member) throws ExportTypeException {
        if (!(annotatedType.getType() instanceof ParameterizedType)) {
            return Optional.empty();
        }
        ParameterizedType type = (ParameterizedType)annotatedType.getType();
        AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
        if (type.getRawType() == Pair.class) {
            TypescriptType firstType = GenericCollectionFieldExporter.getTypescriptTypeForGeneric(parameterizedType, 0, member);
            TypescriptType secondType = GenericCollectionFieldExporter.getTypescriptTypeForGeneric(parameterizedType, 1, member);
            return Optional.of(new TypescriptType("Pair<" + firstType.toNullableType() + ", " + secondType.toNullableType() + ">", GenericCollectionFieldExporter.isNullable(annotatedType)));
        }
        if (type.getRawType() == PairList.class) {
            TypescriptType firstType = GenericCollectionFieldExporter.getTypescriptTypeForGeneric(parameterizedType, 0, member);
            TypescriptType secondType = GenericCollectionFieldExporter.getTypescriptTypeForGeneric(parameterizedType, 1, member);
            return Optional.of(new TypescriptType("PairList<" + firstType.toNullableType() + ", " + secondType.toNullableType() + ">", GenericCollectionFieldExporter.isNullable(annotatedType)));
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            TypescriptType firstType = GenericCollectionFieldExporter.getTypescriptTypeForGeneric(parameterizedType, 0, member);
            return Optional.of(GenericCollectionFieldExporter.arrayWithType(firstType, GenericCollectionFieldExporter.isNullable(annotatedType)));
        }
        return Optional.empty();
    }
}

