/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.abap;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class AbapPreprocessor
implements IPreprocessor {
    private static final int NO_POSITION = -1;
    private static final String INTERFACE_COMMENT_PREFIX = "*\"";
    private static final String INTERFACE_COMMENT_BOUNDARY = "*\"----------------------------------------------------------------------";

    @Override
    public List<IToken> preprocess(String uniformPath, List<IToken> tokens) {
        List<IToken> result = AbapPreprocessor.expandChainSentences(tokens);
        return AbapPreprocessor.uncommentFunctionInterface(result, uniformPath);
    }

    private static List<IToken> expandChainSentences(List<IToken> tokens) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        int lastDot = -1;
        int lastColon = -1;
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(tokens, 0, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
        block5: while (iterator.hasNext()) {
            IToken token = iterator.next();
            int currentIndex = iterator.getCurrentIndex();
            switch (token.getType()) {
                case COLON: {
                    if (lastColon != -1) continue block5;
                    lastColon = currentIndex;
                    continue block5;
                }
                case COMMA: {
                    if (!iterator.isTopLevel() || lastColon == -1) {
                        result.add(token);
                        continue block5;
                    }
                    result.add(TokenStreamUtils.createToken(token, ".", ETokenType.DOT));
                    IToken reference = AbapPreprocessor.getReferenceToken(tokens, currentIndex);
                    List<IToken> toRepeat = tokens.subList(lastDot + 1, lastColon);
                    result.addAll(TokenStreamUtils.copyTokens(reference, toRepeat));
                    continue block5;
                }
                case DOT: {
                    lastDot = currentIndex;
                    lastColon = -1;
                }
            }
            result.add(token);
        }
        return result;
    }

    private static IToken getReferenceToken(List<IToken> tokens, int commaIndex) {
        for (IToken token : tokens.subList(commaIndex + 1, tokens.size())) {
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT) continue;
            return token;
        }
        return tokens.get(commaIndex);
    }

    private static List<IToken> uncommentFunctionInterface(List<IToken> tokens, String uniformPath) {
        int functionTokenIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.FUNCTION);
        if (functionTokenIndex == -1 || tokens.size() < functionTokenIndex + 3 || tokens.get(functionTokenIndex + 2).getType() != ETokenType.DOT || functionTokenIndex > 0 && tokens.get(functionTokenIndex - 1).getType() == ETokenType.CALL) {
            return tokens;
        }
        ArrayList<IToken> result = new ArrayList<IToken>(tokens.subList(0, functionTokenIndex + 3));
        boolean isWithinInterfaceComment = false;
        int processedOriginalTokens = functionTokenIndex + 3;
        while (processedOriginalTokens < tokens.size()) {
            IToken token;
            if ((token = tokens.get(processedOriginalTokens++)).getType() == ETokenType.TRADITIONAL_COMMENT && token.getText().equals(INTERFACE_COMMENT_BOUNDARY)) {
                if (isWithinInterfaceComment) {
                    result.remove(functionTokenIndex + 2);
                    result.add(TokenStreamUtils.createToken(token, ".", ETokenType.DOT));
                    break;
                }
                isWithinInterfaceComment = true;
                continue;
            }
            if (isWithinInterfaceComment) {
                result.addAll(TokenStreamUtils.copyTokens(token, AbapPreprocessor.transformInterfaceCommentToCode(uniformPath, token)));
                continue;
            }
            result.add(token);
        }
        result.addAll(tokens.subList(processedOriginalTokens, tokens.size()));
        return result;
    }

    private static @NonNull List<IToken> transformInterfaceCommentToCode(String uniformPath, IToken token) {
        String uncommentedText = StringUtils.stripPrefix((String)token.getText(), (String)INTERFACE_COMMENT_PREFIX);
        return ScannerUtils.getTokens(uncommentedText, ELanguage.ABAP, uniformPath);
    }

    public static boolean isGeneratedFromAbapKettensatzStatement(UnmodifiableList<IToken> includedTokens) {
        if (includedTokens.size() < 2) {
            return false;
        }
        return ((IToken)includedTokens.get(0)).getOffset() == ((IToken)includedTokens.get(1)).getOffset();
    }
}

