/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.ABAPToken;
import eu.cqse.check.framework.scanner.AbapCdsToken;
import eu.cqse.check.framework.scanner.AbapDocToken;
import eu.cqse.check.framework.scanner.AdaToken;
import eu.cqse.check.framework.scanner.CPPToken;
import eu.cqse.check.framework.scanner.CSToken;
import eu.cqse.check.framework.scanner.CToken;
import eu.cqse.check.framework.scanner.CobolStatementOracle;
import eu.cqse.check.framework.scanner.CobolToken;
import eu.cqse.check.framework.scanner.CppMsCliToken;
import eu.cqse.check.framework.scanner.DartToken;
import eu.cqse.check.framework.scanner.DelphiToken;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ESQLToken;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.FortranToken;
import eu.cqse.check.framework.scanner.GoToken;
import eu.cqse.check.framework.scanner.GosuToken;
import eu.cqse.check.framework.scanner.GroovyToken;
import eu.cqse.check.framework.scanner.HanaSQLScriptToken;
import eu.cqse.check.framework.scanner.IStatementOracle;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.Iec61131Token;
import eu.cqse.check.framework.scanner.JavaDocToken;
import eu.cqse.check.framework.scanner.JavaScriptToken;
import eu.cqse.check.framework.scanner.JavaToken;
import eu.cqse.check.framework.scanner.KotlinToken;
import eu.cqse.check.framework.scanner.LineToken;
import eu.cqse.check.framework.scanner.MatlabToken;
import eu.cqse.check.framework.scanner.NLIssueToken;
import eu.cqse.check.framework.scanner.NLRequirementToken;
import eu.cqse.check.framework.scanner.NLTestToken;
import eu.cqse.check.framework.scanner.OCamlToken;
import eu.cqse.check.framework.scanner.OScriptToken;
import eu.cqse.check.framework.scanner.ObjectiveCToken;
import eu.cqse.check.framework.scanner.ObjectiveCppToken;
import eu.cqse.check.framework.scanner.OpenCLToken;
import eu.cqse.check.framework.scanner.PHPToken;
import eu.cqse.check.framework.scanner.PLSQLToken;
import eu.cqse.check.framework.scanner.PowershellToken;
import eu.cqse.check.framework.scanner.PythonToken;
import eu.cqse.check.framework.scanner.RustToken;
import eu.cqse.check.framework.scanner.StatementOracle;
import eu.cqse.check.framework.scanner.SwiftToken;
import eu.cqse.check.framework.scanner.TSQLToken;
import eu.cqse.check.framework.scanner.TextToken;
import eu.cqse.check.framework.scanner.ToyToken;
import eu.cqse.check.framework.scanner.VBToken;
import eu.cqse.check.framework.scanner.WorkItemStatementOracle;
import eu.cqse.check.framework.scanner.XMLToken;
import eu.cqse.check.framework.scanner.XtendToken;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class LanguageProperties {
    private static final Map<ELanguage, LanguageProperties> LANGUAGE_PROPERTIES_MAPPING = new HashMap<ELanguage, LanguageProperties>();
    private static final String SQL_LIKE_COMMENT_LINE_TRIM_PATTERN = "(^ *(--+|/[*]+))|([*]+/ *$)";
    private final IStatementOracle statementOracle;
    private final Pattern commentLineTrimPattern;
    private final boolean cLike;
    private final ITokenFactory tokenFactory;

    private static void registerCLikeLanguages() {
        LanguageProperties.register(ELanguage.JAVA, JavaToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.CPP, CPPToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.CPP_MS_CLI, CppMsCliToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.C, CToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.OPEN_CL, OpenCLToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.RUST, RustToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.CS, CSToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.JAVASCRIPT, JavaScriptToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.XTEND, XtendToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.EOL}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.SWIFT, SwiftToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.EOL}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.GROOVY, GroovyToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.GOSU, GosuToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.KOTLIN, KotlinToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.EOL, ETokenType.EOF}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.OBJECTIVE_C, ObjectiveCToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.EOL, ETokenType.EOF, ETokenType.INTERFACE, ETokenType.IMPLEMENTATION, ETokenType.END}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.OBJECTIVE_CPP, ObjectiveCppToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.EOL, ETokenType.EOF, ETokenType.INTERFACE, ETokenType.IMPLEMENTATION, ETokenType.END}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.ABAP_CDS, AbapCdsToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.EOF}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.register(ELanguage.DART, DartToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
    }

    private static void registerSqlLanguages() {
        LanguageProperties.register(ELanguage.PLSQL, PLSQLToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON}), SQL_LIKE_COMMENT_LINE_TRIM_PATTERN, false);
        LanguageProperties.register(ELanguage.TSQL, TSQLToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOF}), SQL_LIKE_COMMENT_LINE_TRIM_PATTERN, false);
        LanguageProperties.register(ELanguage.SQLSCRIPT, HanaSQLScriptToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON}), SQL_LIKE_COMMENT_LINE_TRIM_PATTERN, false);
        LanguageProperties.register(ELanguage.ESQL, ESQLToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOF}), SQL_LIKE_COMMENT_LINE_TRIM_PATTERN, false);
    }

    private static void registerWorkItemLanguages() {
        LanguageProperties.register(ELanguage.NL_REQUIREMENTS, NLRequirementToken::new, new WorkItemStatementOracle(), "", false);
        LanguageProperties.register(ELanguage.NL_TESTS, NLTestToken::new, new WorkItemStatementOracle(), "", false);
        LanguageProperties.register(ELanguage.NL_ISSUES, NLIssueToken::new, new WorkItemStatementOracle(), "", false);
    }

    private static void register(ELanguage language, ITokenFactory tokenFactory, Set<ETokenType> statementDelimiters, String commentLineTrimRegex, boolean cLike) {
        LANGUAGE_PROPERTIES_MAPPING.put(language, new LanguageProperties(tokenFactory, new StatementOracle(statementDelimiters), commentLineTrimRegex, cLike));
    }

    private static void register(ELanguage language, ITokenFactory tokenFactory, IStatementOracle oracle, String commentLineTrimRegex, boolean cLike) {
        LANGUAGE_PROPERTIES_MAPPING.put(language, new LanguageProperties(tokenFactory, oracle, commentLineTrimRegex, cLike));
    }

    public static LanguageProperties of(ELanguage language) {
        return LANGUAGE_PROPERTIES_MAPPING.get(language);
    }

    private LanguageProperties(ITokenFactory tokenFactory, IStatementOracle oracle, String commentLineTrimRegex, boolean cLike) {
        this.statementOracle = oracle;
        this.commentLineTrimPattern = Pattern.compile(commentLineTrimRegex);
        this.cLike = cLike;
        this.tokenFactory = tokenFactory;
    }

    public IStatementOracle getStatementOracle() {
        return this.statementOracle;
    }

    public String getCommentContent(String commentText) {
        StringBuilder content = new StringBuilder();
        for (String line : StringUtils.splitLinesAsList((String)commentText)) {
            if (content.length() > 0) {
                content.append(StringUtils.LINE_SEPARATOR);
            }
            content.append(this.commentLineTrimPattern.matcher(line).replaceAll("").trim());
        }
        return content.toString();
    }

    public boolean isCLike() {
        return this.cLike;
    }

    public IToken createToken(ETokenType type, int offset, int lineNumber, String text, String originId) {
        return this.tokenFactory.create(type, offset, lineNumber, text, originId);
    }

    static {
        LanguageProperties.registerCLikeLanguages();
        LanguageProperties.registerSqlLanguages();
        LanguageProperties.register(ELanguage.VB, VBToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.COLON, ETokenType.EOL}), "^ *'", false);
        LanguageProperties.register(ELanguage.COBOL, CobolToken::new, new CobolStatementOracle(), "^ *[*/]+", false);
        LanguageProperties.register(ELanguage.ABAP, ABAPToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.DOT}), "^ *(\"\\!)|([*\"]+)", false);
        LanguageProperties.register(ELanguage.ABAP_DDIC, TextToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL}), "", false);
        LanguageProperties.register(ELanguage.ADA, AdaToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.THEN}), "^ *--+", false);
        LanguageProperties.register(ELanguage.TEXT, TextToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.DOT, ETokenType.QUESTION, ETokenType.EXCLAMATION, ETokenType.COLON, ETokenType.MULTIPLE_EOL}), "", false);
        LanguageProperties.register(ELanguage.XML, XMLToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.RIGHT_ANGLE_BRACKET}), "(^ *<!--+)|(--+>$)", false);
        LanguageProperties.register(ELanguage.HANA_VIEW, XMLToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.RIGHT_ANGLE_BRACKET}), "(^ *<!--+)|(--+>$)", false);
        LanguageProperties.register(ELanguage.PYTHON, PythonToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL, ETokenType.EOF}), "^ *#+", false);
        LanguageProperties.register(ELanguage.MATLAB, MatlabToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON}), "^ *%+", false);
        LanguageProperties.register(ELanguage.PHP, PHPToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", false);
        LanguageProperties.register(ELanguage.LINE, LineToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL}), "", false);
        LanguageProperties.register(ELanguage.KUBERNETES, LineToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL}), "", false);
        LanguageProperties.register(ELanguage.DELPHI, DelphiToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON}), "(^ *([(][*]+|[{]|//+)|([*]+[)]|[}])$)", false);
        LanguageProperties.register(ELanguage.IEC61131, Iec61131Token::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.ELEMENT}), "(^ *([(][*]+|//+)|([*]+[)])$)", false);
        LanguageProperties.register(ELanguage.FORTRAN, FortranToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL}), "^ *!+", false);
        LanguageProperties.register(ELanguage.OCAML, OCamlToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "", false);
        LanguageProperties.register(ELanguage.OSCRIPT, OScriptToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL, ETokenType.EOF}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", false);
        LanguageProperties.register(ELanguage.SIMULINK, TextToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL}), "", false);
        LanguageProperties.register(ELanguage.JAVADOC, JavaDocToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[0]), "", false);
        LanguageProperties.register(ELanguage.ABAPDOC, AbapDocToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[0]), "", false);
        LanguageProperties.register(ELanguage.GO, GoToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.EOL, ETokenType.EOF}), "", false);
        LanguageProperties.register(ELanguage.POWERSHELL, PowershellToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOL, ETokenType.RBRACE}), "", false);
        LanguageProperties.register(ELanguage.TOY, ToyToken::new, CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), "(^[ \\t]*(/[*]+\\!?\\<?|//+\\!?\\<?|[*]+(?!/)))|([*]+/$)", true);
        LanguageProperties.registerWorkItemLanguages();
    }

    @FunctionalInterface
    private static interface ITokenFactory {
        public IToken create(ETokenType var1, int var2, int var3, String var4, String var5);
    }
}

