/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;

public class BuilderMethodCallChainsExtractor {
    private static final Logger LOGGER = LogManager.getLogger();

    public static @NonNull MethodCallChains extractMethodCallChains(ShallowEntity method) {
        TreeMap<Integer, MethodCallChain> chains = new TreeMap<Integer, MethodCallChain>();
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(List.of(Objects.requireNonNull(method.getParent())), EnumSet.of(EShallowEntityType.ATTRIBUTE), Set.of("attribute"));
        HashSet<String> potentialBuilderIdentifiers = new HashSet<String>(attributes.stream().map(ShallowEntity::getName).toList());
        potentialBuilderIdentifiers.addAll(LanguageFeatureParser.JAVA.getSplitParameterTokens(method).stream().map(p -> ((IToken)p.getLast()).getText()).toList());
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(method), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            UnmodifiableList tokens = statement.includedTokens();
            for (int callIndex : TokenStreamUtils.firstTokenOfTypeSequences((List<IToken>)tokens, 0, ETokenType.IDENTIFIER, ETokenType.LPAREN)) {
                BuilderMethodCallChainsExtractor.extractMethodCallChain(callIndex, (List<IToken>)tokens, chains, potentialBuilderIdentifiers);
            }
        }
        return new MethodCallChains(chains.values().stream().toList());
    }

    private static void extractMethodCallChain(int callIndex, List<IToken> tokens, TreeMap<Integer, MethodCallChain> chains, Set<String> potentialBuilderIdentifiers) {
        ArrayList<MethodCall> chain = new ArrayList<MethodCall>();
        chain.add(BuilderMethodCallChainsExtractor.extractCall(callIndex, tokens));
        callIndex = BuilderMethodCallChainsExtractor.getStartOfFullyQualifiedCall(callIndex, tokens);
        while (callIndex >= 2 && tokens.get(callIndex - 1).getType() == ETokenType.DOT && tokens.get(callIndex - 2).getType() == ETokenType.RPAREN) {
            int start = TokenStreamUtils.findMatchingOpeningToken(tokens, callIndex - 3, Set.of(ETokenType.LPAREN, ETokenType.LBRACE), Set.of(ETokenType.RPAREN, ETokenType.RBRACE));
            if (start == -1) {
                LOGGER.warn("Missing open parenthesis in method call chain, skipping rest of call chain");
                break;
            }
            start = Math.max(start - 1, 0);
            chain.addFirst(BuilderMethodCallChainsExtractor.extractCall(start, tokens));
            callIndex = BuilderMethodCallChainsExtractor.getStartOfFullyQualifiedCall(start, tokens);
        }
        Set<String> readingIdentifiers = BuilderMethodCallChainsExtractor.getPossiblyRelatedIdentifiers(chain);
        readingIdentifiers.retainAll(potentialBuilderIdentifiers);
        HashSet<String> writingIdentifiers = new HashSet<String>(readingIdentifiers);
        if (callIndex > 0 && tokens.get(callIndex - 1).getType() == ETokenType.EQ) {
            writingIdentifiers.add(tokens.get(callIndex - 2).getText());
            potentialBuilderIdentifiers.add(tokens.get(callIndex - 2).getText());
        }
        MethodCallChain methodCallChain = new MethodCallChain(chain, writingIdentifiers, readingIdentifiers);
        chains.put(methodCallChain.getOffset(), methodCallChain);
    }

    private static @NonNull Set<String> getPossiblyRelatedIdentifiers(List<MethodCall> calls) {
        HashSet<String> possiblyRelatedIdentifiers = new HashSet<String>();
        if (calls.getFirst().identifier().size() == 3) {
            possiblyRelatedIdentifiers.add(calls.getFirst().identifier().getFirst().getText());
        }
        for (MethodCall call : calls) {
            for (List<IToken> argument : call.arguments()) {
                if (argument.isEmpty()) {
                    BuilderMethodCallChainsExtractor.warnAboutEmptyArgument(call);
                    continue;
                }
                if (argument.getFirst().getType() != ETokenType.IDENTIFIER) continue;
                possiblyRelatedIdentifiers.add(argument.getFirst().getText());
            }
        }
        return possiblyRelatedIdentifiers;
    }

    private static @NonNull MethodCall extractCall(int methodCallIdentifierIndex, List<IToken> tokens) {
        int startOfFullyQualifiedCall = BuilderMethodCallChainsExtractor.getStartOfFullyQualifiedCall(methodCallIdentifierIndex, tokens);
        List<IToken> identifier = tokens.subList(startOfFullyQualifiedCall, methodCallIdentifierIndex + 1);
        Pair<List<List<IToken>>, Integer> parametersAndOffset = TokenStreamUtils.splitWithNestingHalting(tokens.subList(methodCallIdentifierIndex + 2, tokens.size()), ETokenType.COMMA, List.of(ETokenType.LPAREN, ETokenType.LBRACE), List.of(ETokenType.RPAREN, ETokenType.RBRACE));
        return new MethodCall(identifier, (List)parametersAndOffset.getFirst());
    }

    private static int getStartOfFullyQualifiedCall(int callIndex, List<IToken> tokens) {
        while (callIndex >= 2 && tokens.get(callIndex - 1).getType() == ETokenType.DOT && tokens.get(callIndex - 2).getType() == ETokenType.IDENTIFIER) {
            callIndex -= 2;
        }
        return callIndex;
    }

    private static void warnAboutEmptyArgument(MethodCall call) {
        if (call.identifier().isEmpty()) {
            LOGGER.warn("Call argument must contain at least one token, but was empty.");
        } else {
            IToken token = call.identifier().getFirst();
            int displayLineNumber = token.getLineNumber() + 1;
            LOGGER.warn("Call argument must contain at least one token, but was empty. Possible syntax error in {} in line {} within {}(...)", (Object)token.getOriginId(), (Object)displayLineNumber, (Object)token.getText());
        }
    }

    public record MethodCallChains(List<MethodCallChain> chains) {
        public List<MethodCallChain> getRelated(int i) {
            return CollectionUtils.asUnmodifiable(this.getRelatedRecursive(i).values().stream().toList());
        }

        private TreeMap<Integer, MethodCallChain> getRelatedRecursive(int i) {
            TreeMap<Integer, MethodCallChain> related = new TreeMap<Integer, MethodCallChain>();
            HashSet<String> myRelatedIdentifiers = new HashSet<String>(this.chains.get(i).readingIdentifiers());
            for (int j = i - 1; j >= 0; --j) {
                HashSet<String> s = new HashSet<String>(this.chains.get(j).writingIdentifiers());
                s.retainAll(myRelatedIdentifiers);
                if (s.isEmpty()) continue;
                myRelatedIdentifiers.removeAll(s);
                related.put(this.chains.get(j).getOffset(), this.chains.get(j));
                related.putAll(this.getRelatedRecursive(j));
            }
            related.put(this.chains.get(i).getOffset(), this.chains.get(i));
            return related;
        }

        @Override
        public @NonNull String toString() {
            return this.chains.stream().map(MethodCallChain::toString).collect(Collectors.joining("\n"));
        }
    }

    public record MethodCall(List<IToken> identifier, List<List<IToken>> arguments) {
        public MethodCall(List<IToken> identifier, List<List<IToken>> arguments) {
            this.identifier = CollectionUtils.asUnmodifiable(identifier);
            this.arguments = CollectionUtils.asUnmodifiable(arguments);
        }

        @Override
        public @NonNull String toString() {
            return TokenStreamTextUtils.concatTokenTexts(this.identifier) + "(" + this.arguments.stream().map(TokenStreamTextUtils::concatTokenTexts).collect(Collectors.joining(", ")) + ")";
        }
    }

    public record MethodCallChain(List<MethodCall> calls, Set<String> writingIdentifiers, Set<String> readingIdentifiers) {
        public MethodCallChain(List<MethodCall> calls, Set<String> writingIdentifiers, Set<String> readingIdentifiers) {
            this.calls = CollectionUtils.asUnmodifiable(calls);
            this.writingIdentifiers = CollectionUtils.asUnmodifiable(writingIdentifiers);
            this.readingIdentifiers = CollectionUtils.asUnmodifiable(readingIdentifiers);
        }

        private int getOffset() {
            return this.calls.getFirst().identifier().getFirst().getOffset();
        }

        @Override
        public @NonNull String toString() {
            return String.valueOf(this.writingIdentifiers) + " = " + this.calls.stream().map(MethodCall::toString).collect(Collectors.joining(".")) + " // reading from " + String.valueOf(this.readingIdentifiers);
        }
    }
}

