/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core;

import com.microsoft.tfs.core.ServerCapabilities;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.authorization.QueryMembership;
import com.microsoft.tfs.core.clients.authorization.SearchFactor;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.location.AccessMapping;
import com.microsoft.tfs.core.clients.framework.location.ConnectOptions;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.core.clients.groupsecurity.GroupSecurityClient;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.registration.ServiceInterface;
import com.microsoft.tfs.core.clients.serverstatus.ServerStatusClient;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.exceptions.FrameworkMethodNotImplementedException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreFrameworkServerDataProvider
implements ServerDataProvider {
    private static final Log log = LogFactory.getLog(PreFrameworkServerDataProvider.class);
    private final TFSTeamProjectCollection teamProjectCollection;
    private RegistrationClient registrationClient;
    private final Object registrationClientLock = new Object();
    private volatile TeamFoundationIdentity authenticatedIdentity;
    private static final Map<String, String> SERVICE_TYPE_IDENTIFIER_TO_TOOL = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    private static String getServiceTypeIdentifierKey(String serviceType, GUID identifier) {
        if ("IProjectMaintenance".equalsIgnoreCase(serviceType) || "LinkingProviderService".equalsIgnoreCase(serviceType) || "IBISEnablement".equalsIgnoreCase(serviceType)) {
            return serviceType + " - " + identifier.getGUIDString();
        }
        return serviceType;
    }

    public PreFrameworkServerDataProvider(TFSTeamProjectCollection teamProjectCollection) {
        Check.notNull(teamProjectCollection, "teamProjectCollection");
        this.teamProjectCollection = teamProjectCollection;
    }

    @Override
    public GUID getInstanceID() {
        return this.getRegistrationClient().getInstanceID();
    }

    @Override
    public GUID getCatalogResourceID() {
        return GUID.EMPTY;
    }

    @Override
    public TeamFoundationIdentity getAuthenticatedIdentity() {
        if (this.authenticatedIdentity == null) {
            this.authenticate();
        }
        return this.authenticatedIdentity;
    }

    @Override
    public TeamFoundationIdentity getAuthorizedIdentity() {
        return this.getAuthenticatedIdentity();
    }

    @Override
    public boolean hasAuthenticated() {
        return this.authenticatedIdentity != null;
    }

    @Override
    public void ensureAuthenticated() {
        if (!this.hasAuthenticated()) {
            this.authenticate();
        }
    }

    @Override
    public void authenticate() {
        ServerStatusClient serverStatusClient = (ServerStatusClient)this.teamProjectCollection.getClient(ServerStatusClient.class);
        String authenticatedUserName = serverStatusClient.checkAuthentication();
        GroupSecurityClient groupSecurityClient = (GroupSecurityClient)this.teamProjectCollection.getClient(GroupSecurityClient.class);
        this.authenticatedIdentity = groupSecurityClient.convert(groupSecurityClient.readIdentity(SearchFactor.ACCOUNT_NAME, authenticatedUserName, QueryMembership.NONE));
    }

    @Override
    public String locationForCurrentConnection(ServiceDefinition serviceDefinition) {
        return this.locationForCurrentConnection(serviceDefinition.getServiceType(), new GUID(serviceDefinition.getIdentifier()));
    }

    @Override
    public String locationForCurrentConnection(String serviceType, GUID serviceIdentifier) {
        String key = PreFrameworkServerDataProvider.getServiceTypeIdentifierKey(serviceType, serviceIdentifier);
        String toolID = "";
        if (SERVICE_TYPE_IDENTIFIER_TO_TOOL.containsKey(key)) {
            toolID = SERVICE_TYPE_IDENTIFIER_TO_TOOL.get(key);
        }
        return this.findServiceLocation(serviceType, toolID);
    }

    public String findServiceLocation(String serviceType, String toolID) {
        Check.notNull(toolID, "toolID");
        RegistrationEntry[] entries = this.getRegistrationClient().getRegistrationEntries();
        if (entries != null && entries.length > 0) {
            for (int i = 0; i < entries.length; ++i) {
                RegistrationEntry entry = entries[i];
                if (toolID.length() != 0 && !toolID.toLowerCase().equals(entry.getType().toLowerCase())) continue;
                ServiceInterface[] services = entries[i].getServiceInterfaces();
                for (int j = 0; j < services.length; ++j) {
                    ServiceInterface service = services[j];
                    if (!serviceType.equalsIgnoreCase(service.getName())) continue;
                    return service.getURL();
                }
            }
        }
        log.debug((Object)MessageFormat.format("Couldn't find a ServiceInterface for toolID {0}, serviceType {1}", toolID, serviceType));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistrationClient getRegistrationClient() {
        Object object = this.registrationClientLock;
        synchronized (object) {
            if (this.registrationClient == null) {
                this.registrationClient = new RegistrationClient(this.teamProjectCollection);
            }
            return this.registrationClient;
        }
    }

    @Override
    public void connect(ConnectOptions connectOptions) {
        throw new FrameworkMethodNotImplementedException("connect");
    }

    @Override
    public String findServerLocation(GUID serverGUID) {
        throw new FrameworkMethodNotImplementedException("findServerLocation");
    }

    @Override
    public void reactToPossibleServerUpdate(int serverLastChangeId) {
        throw new FrameworkMethodNotImplementedException("reactToPossibleServerUpdate");
    }

    @Override
    public AccessMapping configureAccessMapping(String moniker, String displayName, String accessPoint, boolean makeDefault) {
        throw new FrameworkMethodNotImplementedException("configureAccessMapping");
    }

    @Override
    public ServiceDefinition findServiceDefinition(String serviceType, GUID serviceIdentifier) {
        throw new FrameworkMethodNotImplementedException("findServiceDefinition");
    }

    @Override
    public ServiceDefinition[] findServiceDefinitions(String serviceType) {
        throw new FrameworkMethodNotImplementedException("findServiceDefinitions");
    }

    @Override
    public ServiceDefinition[] findServiceDefinitionsByToolType(String toolType) {
        throw new FrameworkMethodNotImplementedException("findServiceDefinitionsByToolType");
    }

    @Override
    public AccessMapping getAccessMapping(String moniker) {
        throw new FrameworkMethodNotImplementedException("getAccessMapping");
    }

    @Override
    public AccessMapping getClientAccessMapping() {
        throw new FrameworkMethodNotImplementedException("getClientAccessMapping");
    }

    @Override
    public AccessMapping[] getConfiguredAccessMappings() {
        throw new FrameworkMethodNotImplementedException("getConfiguredAccessMappings");
    }

    @Override
    public AccessMapping getDefaultAccessMapping() {
        throw new FrameworkMethodNotImplementedException("getDefaultAccessMapping");
    }

    @Override
    public String locationForAccessMapping(String serviceType, GUID serviceIdentifier, AccessMapping accessMapping) {
        throw new FrameworkMethodNotImplementedException("locationForAccessMapping");
    }

    @Override
    public String locationForAccessMapping(ServiceDefinition serviceDefinition, AccessMapping accessMapping) {
        throw new FrameworkMethodNotImplementedException("locationForAccessMapping");
    }

    @Override
    public String locationForAccessMapping(ServiceDefinition serviceDefinition, AccessMapping accessMapping, boolean encodeRelativeComponents) {
        throw new FrameworkMethodNotImplementedException("locationForAccessMapping");
    }

    @Override
    public void removeAccessMapping(String moniker) {
        throw new FrameworkMethodNotImplementedException("removeAccessMapping");
    }

    @Override
    public void removeServiceDefinition(String serviceType, GUID serviceIdentifier) {
        throw new FrameworkMethodNotImplementedException("removeServiceDefinition");
    }

    @Override
    public void removeServiceDefinition(ServiceDefinition serviceDefinition) {
        throw new FrameworkMethodNotImplementedException("removeServiceDefinition");
    }

    @Override
    public void removeServiceDefinitions(ServiceDefinition[] serviceDefinitions) {
        throw new FrameworkMethodNotImplementedException("removeServiceDefinitions");
    }

    @Override
    public void saveServiceDefinition(ServiceDefinition serviceDefinition) {
        throw new FrameworkMethodNotImplementedException("saveServiceDefinition");
    }

    @Override
    public void saveServiceDefinitions(ServiceDefinition[] serviceDefinitions) {
        throw new FrameworkMethodNotImplementedException("saveServiceDefinitions");
    }

    @Override
    public void setDefaultAccessMapping(AccessMapping accessMapping) {
        throw new FrameworkMethodNotImplementedException("setDefaultAccessMapping");
    }

    @Override
    public ServerCapabilities getServerCapabilities() {
        return ServerCapabilities.NONE;
    }

    static {
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("BuildStoreService", "Build");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("BuildControllerService", "Build");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("LinkingProviderService", new GUID("204687d1-5df8-493c-bcda-e43a19b935e9")), "Build");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("PublishTestResultsBuildService", "Build");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("BuildService", "Build");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("CommonStructure", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("Eventing", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("GroupSecurity", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("GroupSecurity2", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("Authorization", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("ProcessTemplate", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("Methodology", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("MethodologyUpload", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("RegistrationService", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("ServerStatus", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("IProjectMaintenance  ", new GUID("855c71c3-4f2c-4fde-a140-fb265f0ff0fa")), "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("ITeamSystemTask", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("Warehouse", "vstfs");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("ReportsService", "Reports");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("BaseReportsUrl", "Reports");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("DataSourceServer", "Reports");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("WssAdminService", "Wss");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("BaseServerUrl", "Wss");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("BaseSiteUrl", "Wss");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("BaseSiteUnc", "Wss");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("WorkitemService", "WorkItemTracking");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("ConfigurationSettingsUrl", "WorkItemTracking");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("IBISEnablement", new GUID("3c2d1e28-018a-4b97-8989-30695a7e335f")), "WorkItemTracking");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("LinkingProviderService", new GUID("40329fc1-f737-4ef8-807f-b91856676a56")), "WorkItemTracking");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("LinkingConsumerService", "WorkItemTracking");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("IProjectMaintenance  ", new GUID("9de13285-caec-43cd-8c20-2848dd58d7dd")), "WorkItemTracking");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("ISCCProvider", "VersionControl");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("ISCCAdmin", "VersionControl");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("IBISEnablement", new GUID("64de386c-b1be-41ad-b8cb-27ca22d48563")), "VersionControl");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("LinkingProviderService", new GUID("10a3ab2b-7140-4b4b-a72a-0feca94d5b6d")), "VersionControl");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put(PreFrameworkServerDataProvider.getServiceTypeIdentifierKey("IProjectMaintenance  ", new GUID("750c198b-30f9-4088-9649-30be07853310")), "VersionControl");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("Download", "VersionControl");
        SERVICE_TYPE_IDENTIFIER_TO_TOOL.put("Upload", "VersionControl");
    }
}

