/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes;

import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributesEntry;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileAttributesFile {
    private static final Log log = LogFactory.getLog(FileAttributesFile.class);
    public static final String DEFAULT_FILENAME = ".tpattributes";
    public static final char COMMENT_CHAR = '#';

    public static List<FileAttributesEntry> loadGlobalFile(String localPath) {
        Check.notNullOrEmpty(localPath, "localPath");
        return FileAttributesFile.loadFile(localPath, new AttributesLineTransformation(){

            @Override
            public String transform(String line) {
                if (line.startsWith("$/")) {
                    return "\\" + line;
                }
                return line;
            }
        });
    }

    public static List<FileAttributesEntry> loadAttributesFile(String localPath) {
        Check.notNullOrEmpty(localPath, "localPath");
        return FileAttributesFile.loadFile(localPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileAttributesEntry> loadFile(String localPath, AttributesLineTransformation lineTransformation) {
        File file = new File(localPath);
        if (!file.exists()) {
            return null;
        }
        ArrayList<FileAttributesEntry> entries = new ArrayList<FileAttributesEntry>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = StringUtil.trimBegin(line)).length() == 0 || line.startsWith("#") || lineTransformation != null && StringUtil.isNullOrEmpty(line = lineTransformation.transform(line))) continue;
                try {
                    FileAttributesEntry e = FileAttributesEntry.parse(line);
                    entries.add(e);
                }
                catch (PatternSyntaxException e) {
                    log.warn((Object)MessageFormat.format("Ignoring entry for invalid regular expression at line {0} of file {1}", lineNumber, localPath), (Throwable)e);
                }
                catch (ParseException e) {
                    log.warn((Object)MessageFormat.format("Ignoring malformed file attributes entry at line {0} of file {1}", lineNumber, localPath));
                }
            }
        }
        catch (IOException e) {
            log.error((Object)MessageFormat.format("Error reading attributes file {0}: {1}", localPath, e.getMessage()));
            List<FileAttributesEntry> list = null;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return entries;
    }

    private static interface AttributesLineTransformation {
        public String transform(String var1);
    }
}

