/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.EnumeratedLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class LocalItemEnumerator
implements Iterator<EnumeratedLocalItem> {
    private final boolean recurse;
    private final boolean enumerateHiddenAndSystem;
    private final String startPath;
    private final Object tag;
    private Set<String> excludedPaths;
    private File[] currentFileList;
    private int currentFileListIndex;
    private EnumeratedLocalItem currentLocalItem;
    private final Stack<Queue<File>> stateStack;

    public LocalItemEnumerator(File startPath, boolean recurse, boolean enumerateHiddenAndSystem, List<String> excludedPaths, Object tag) {
        Check.notNull(startPath, "startPath");
        this.recurse = recurse;
        this.enumerateHiddenAndSystem = enumerateHiddenAndSystem;
        this.startPath = startPath.getPath();
        this.tag = tag;
        if (null != excludedPaths && excludedPaths.size() > 0) {
            this.excludedPaths = new TreeSet<String>(LocalPath.TOP_DOWN_COMPARATOR);
            this.excludedPaths.addAll(excludedPaths);
        }
        if (!startPath.exists()) {
            this.currentFileList = new File[0];
        } else if (startPath.isDirectory()) {
            this.currentFileList = startPath.listFiles();
        } else if (startPath.isFile()) {
            this.currentFileList = new File[]{startPath};
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Don''t know how to handle startPath {0} which is not a file or directory", startPath));
        }
        this.currentFileListIndex = 0;
        this.stateStack = new Stack();
        this.stateStack.push(new LinkedList());
    }

    public String getStartPath() {
        return this.startPath;
    }

    public Object getTag() {
        return this.tag;
    }

    public void addExcludedPath(String localItem) {
        if (null == this.excludedPaths) {
            this.excludedPaths = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.excludedPaths.add(localItem);
    }

    private boolean moveNext() {
        while (true) {
            if (this.currentFileList != null && this.currentFileListIndex < this.currentFileList.length) {
                File currentFile;
                if ((currentFile = this.currentFileList[this.currentFileListIndex++]).getName().equals(".") || currentFile.getName().equals("..")) continue;
                FileSystemAttributes fileAttrs = null;
                if (!this.enumerateHiddenAndSystem) {
                    try {
                        fileAttrs = FileSystemUtils.getInstance().getAttributes(currentFile.getPath());
                        if (fileAttrs.isHidden()) {
                        }
                    }
                    catch (RuntimeException e) {}
                    continue;
                }
                if (BaselineFolder.isPotentialBaselineFolderName(currentFile.getName()) || this.excludedPaths != null && this.excludedPaths.contains(currentFile.getPath())) continue;
                if (fileAttrs == null) {
                    fileAttrs = FileSystemUtils.getInstance().getAttributes(currentFile.getPath());
                }
                if (this.recurse && fileAttrs.isDirectory() && !fileAttrs.isSymbolicLink()) {
                    this.stateStack.peek().add(currentFile);
                }
                this.currentLocalItem = new EnumeratedLocalItem(currentFile, fileAttrs);
                return true;
            }
            while (this.stateStack.size() > 0) {
                if (this.stateStack.peek().size() > 0) {
                    File subDir = this.stateStack.peek().poll();
                    this.stateStack.push(new LinkedList());
                    this.currentFileList = subDir.listFiles();
                    this.currentFileListIndex = 0;
                    break;
                }
                this.stateStack.pop();
            }
            if (this.stateStack.size() == 0) break;
        }
        this.currentLocalItem = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.currentLocalItem != null) {
            return true;
        }
        return this.moveNext();
    }

    @Override
    public EnumeratedLocalItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        EnumeratedLocalItem toReturn = this.currentLocalItem;
        this.moveNext();
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

