/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderType;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import ms.tfs.versioncontrol.clientservices._03._Mapping;
import ms.tfs.versioncontrol.clientservices._03._WorkingFolderType;

public abstract class Mapping
extends WebServiceObjectWrapper {
    private static final int DEPTH_ONE_LEVEL = 1;
    private static final int DEPTH_FULL = 120;

    public Mapping() {
        super(new _Mapping());
    }

    public Mapping(_Mapping mapping) {
        super(mapping);
    }

    public Mapping(String serverItem, WorkingFolderType type, RecursionType recursion) {
        super(new _Mapping(serverItem, type.getWebServiceObject(), Mapping.getDepthFromRecursion(recursion)));
    }

    private _Mapping getWebServiceObject() {
        return (_Mapping)this.webServiceObject;
    }

    protected static int getDepthFromRecursion(RecursionType recursion) {
        Check.notNull(recursion, "recursion");
        if (recursion == RecursionType.FULL) {
            return 120;
        }
        if (recursion == RecursionType.ONE_LEVEL) {
            return 1;
        }
        return 120;
    }

    public String getServerItem() {
        return this.getWebServiceObject().getItem();
    }

    public void setServerItem(String item) {
        Check.notNull(item, "item");
        this.getWebServiceObject().setItem(item);
    }

    public String getDisplayServerItem() {
        if (this.getWebServiceObject().getDepth() == 1) {
            return this.getWebServiceObject().getItem() + "/*";
        }
        return this.getWebServiceObject().getItem();
    }

    public WorkingFolderType getType() {
        return WorkingFolderType.fromWebServiceObject(this.getWebServiceObject().getType());
    }

    public RecursionType getDepth() {
        if (this.getWebServiceObject().getDepth() == 1) {
            return RecursionType.ONE_LEVEL;
        }
        return RecursionType.FULL;
    }

    public boolean isCloaked() {
        return this.getWebServiceObject().getType().equals(_WorkingFolderType.Cloak);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Mapping)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Mapping other = (Mapping)obj;
        return ServerPath.equals(this.getServerItem(), other.getServerItem()) && this.getDepth().equals(other.getDepth()) && this.getType().equals(other.getType());
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.getWebServiceObject().getItem() == null ? 0 : this.getWebServiceObject().getItem().hashCode());
        return result;
    }
}

